/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private OutputStream out;
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream out) {
        this.out = out;
    }

    protected void updateBytesWritten(long delta) {
        this.bytesWritten += delta;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.updateBytesWritten(1L);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.updateBytesWritten(len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

