/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.progeeks.util.Inspector;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.ObservableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObservableList<E>
implements ObservableList<E>,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private List<E> list;
    private String propertyName;
    private transient List<PropertyChangeListener> listeners;

    public DefaultObservableList() {
        this("list", new ArrayList());
    }

    public DefaultObservableList(List<E> list) {
        this("list", list);
    }

    public DefaultObservableList(String propertyName, List<E> list) {
        this.propertyName = propertyName;
        this.list = list;
    }

    public Object clone() throws CloneNotSupportedException {
        Inspector ins;
        DefaultObservableList clone = (DefaultObservableList)super.clone();
        clone.listeners = null;
        if (this.list instanceof Cloneable && (ins = new Inspector(this.list)).hasMethod("clone")) {
            clone.list = (List)ins.callMethod("clone");
        }
        return clone;
    }

    protected void setList(List<E> list) {
        if (this.list != null) {
            throw new IllegalStateException("Internal List cannot be changed once set.");
        }
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ObservableIterator(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E o) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        boolean result = this.list.add(o);
        if (result) {
            this.fireElementsInserted(this.list.size() - 1, this.list.size() - 1, original);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.list.indexOf(o);
        if (index < 0) {
            return false;
        }
        ArrayList<E> original = new ArrayList<E>(this.list);
        boolean retVal = this.list.remove(o);
        if (retVal) {
            this.fireElementsRemoved(index, index, original);
        }
        return retVal;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        int index = this.list.size();
        boolean retVal = this.list.addAll(c);
        int insertSize = this.list.size() - index;
        if (retVal) {
            this.fireElementsInserted(index, index + insertSize - 1, original);
        }
        return retVal;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        int oldSize = this.list.size();
        boolean retVal = this.list.addAll(index, c);
        int insertSize = this.list.size() - oldSize;
        if (retVal) {
            this.fireElementsInserted(index, index + insertSize - 1, original);
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        int size = this.list.size();
        if (size == 0) {
            return;
        }
        ArrayList<E> original = new ArrayList<E>(this.list);
        this.list.clear();
        this.fireElementsRemoved(0, size - 1, original);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ObservableList) {
            return ((Object)((DefaultObservableList)o).list).equals(this.list);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        E retVal = this.list.set(index, element);
        this.fireElementsModified(index, index, original);
        return retVal;
    }

    @Override
    public void add(int index, E element) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        this.list.add(index, element);
        this.fireElementsInserted(index, index, original);
    }

    @Override
    public E remove(int index) {
        ArrayList<E> original = new ArrayList<E>(this.list);
        E retVal = this.list.remove(index);
        this.fireElementsRemoved(index, index, original);
        return retVal;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ObservableListIterator(0, this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ObservableListIterator(index, this.list.listIterator(index));
    }

    @Override
    public List<E> subList(int from, int to) {
        return new DefaultObservableList<E>(this.list.subList(from, to));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        PropertyChangeListener[] array = new PropertyChangeListener[this.listeners.size()];
        array = this.listeners.toArray(array);
        for (int i = 0; i < array.length; ++i) {
            array[i].propertyChange(event);
        }
    }

    protected void fireElementsInserted(int first, int last, List<E> original) {
        ListPropertyChangeEvent event = new ListPropertyChangeEvent(this, this.getPropertyName(), original, this.list, first, last, 0);
        this.firePropertyChangeEvent(event);
    }

    protected void fireElementsModified(int first, int last, List<E> original) {
        ListPropertyChangeEvent event = new ListPropertyChangeEvent(this, this.getPropertyName(), original, this.list, first, last, 1);
        this.firePropertyChangeEvent(event);
    }

    protected void fireElementsRemoved(int first, int last, List<E> original) {
        ListPropertyChangeEvent event = new ListPropertyChangeEvent(this, this.getPropertyName(), original, this.list, first, last, 2);
        this.firePropertyChangeEvent(event);
    }

    public String toString() {
        return this.list.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObservableListIterator
    extends ObservableIterator
    implements ListIterator<E> {
        ListIterator<E> listItr;

        public ObservableListIterator(int index, ListIterator<E> itr) {
            super(itr);
            this.listItr = itr;
            this.index = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.listItr.hasPrevious();
        }

        @Override
        public E previous() {
            Object ret = this.listItr.previous();
            this.lastIndex = --this.index;
            return ret;
        }

        @Override
        public int nextIndex() {
            return this.listItr.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.listItr.previousIndex();
        }

        @Override
        public void set(E o) {
            ArrayList original = new ArrayList(DefaultObservableList.this.list);
            this.listItr.set(o);
            DefaultObservableList.this.fireElementsModified(this.index, this.index, original);
        }

        @Override
        public void add(E o) {
            ArrayList original = new ArrayList(DefaultObservableList.this.list);
            this.listItr.add(o);
            DefaultObservableList.this.fireElementsInserted(this.index, this.index, original);
            this.lastIndex = -1;
            ++this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObservableIterator
    implements Iterator<E> {
        Iterator<E> itr;
        int index = 0;
        int lastIndex = -1;

        public ObservableIterator(Iterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            Object retVal = this.itr.next();
            this.lastIndex = this.index++;
            return retVal;
        }

        @Override
        public void remove() {
            ArrayList original = new ArrayList(DefaultObservableList.this.list);
            this.itr.remove();
            DefaultObservableList.this.fireElementsRemoved(this.lastIndex, this.lastIndex, original);
            if (this.lastIndex < this.index) {
                --this.index;
            }
            this.lastIndex = -1;
        }
    }
}

