/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import org.progeeks.util.ObservableMap;
import org.progeeks.util.PropertyRegistry;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.TemplateExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyRegistry
extends ObservableMap
implements PropertyRegistry {
    static final long serialVersionUID = 1L;
    private SimpleExpressionLanguage expLang;
    private TemplateExpressionProcessor rootProcessor;

    public DefaultPropertyRegistry(SimpleExpressionLanguage expLang) {
        this.expLang = expLang;
        this.rootProcessor = this.createTemplateProcessor(this);
    }

    protected TemplateExpressionProcessor createTemplateProcessor(Object target) {
        return new TemplateExpressionProcessor(target, this.expLang);
    }

    public SimpleExpressionLanguage getExpressionLanguage() {
        return this.expLang;
    }

    public TemplateExpressionProcessor getTemplateExpressionProcessor() {
        return this.rootProcessor;
    }

    @Override
    public <T> T getProperty(String propertyId) {
        return this.getProperty(this, propertyId);
    }

    @Override
    public void setProperty(String propertyId, Object value) {
        this.setProperty(this, propertyId, value);
    }

    @Override
    public Object evaluateExpression(TemplateExpressionProcessor.TemplateExpression exp) {
        if (exp == null) {
            return null;
        }
        return this.rootProcessor.evaluate(exp);
    }

    @Override
    public Object evaluateExpression(String exp) {
        return this.evaluateExpression(new TemplateExpressionProcessor.TemplateExpression(exp));
    }

    @Override
    public <T> T getProperty(Object relativeTo, String propertyId) {
        return (T)this.expLang.getProperty(relativeTo, propertyId);
    }

    @Override
    public void setProperty(Object relativeTo, String propertyId, Object value) {
        this.expLang.setProperty(relativeTo, propertyId, value);
    }

    @Override
    public Object evaluateExpression(Object relativeTo, TemplateExpressionProcessor.TemplateExpression exp) {
        if (exp == null) {
            return null;
        }
        return this.rootProcessor.evaluate(relativeTo, exp);
    }

    @Override
    public Object evaluateExpression(Object relativeTo, String exp) {
        return this.evaluateExpression(relativeTo, new TemplateExpressionProcessor.TemplateExpression(exp));
    }
}

