/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtils {
    static final Log log = Log.getLog(EnumUtils.class);

    public static String enumeratedStringValue(Enum<?> value) {
        return value == null ? null : value.toString();
    }

    public static <T extends Enum<T>> T enumeratedValue(Class<T> enumType, String name, T defaultValue) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid enumerated value of '" + name + "' for " + enumType.getSimpleName() + "; using default '" + defaultValue + "'.");
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T enumeratedValue(Class<T> enumType, String name) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid enumerated value of '" + name + "' for " + enumType.getSimpleName());
        }
    }
}

