/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeListener;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.PropertyDependencyManager;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.TemplateExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionSupport {
    public static final String TEMPLATE_EXPRESSION_LABEL = "!expressionValue";
    private SimpleExpressionLanguage expLang;
    private TemplateExpressionProcessor templateProcessor;
    private PropertyDependencyManager depMgr;

    public ExpressionSupport(PropertyDependencyManager depMgr) {
        this.depMgr = depMgr;
        this.templateProcessor = depMgr.getTemplateProcessor();
        this.expLang = this.templateProcessor.getExpressionLanguage();
    }

    public ExpressionSupport(PropertyAccess access) {
        this.expLang = new SimpleExpressionLanguage(access);
        this.templateProcessor = new TemplateExpressionProcessor(this.expLang);
        this.depMgr = new PropertyDependencyManager(this.templateProcessor);
    }

    public SimpleExpressionLanguage getExpressionLanguage() {
        return this.expLang;
    }

    public TemplateExpressionProcessor getTemplateExpressionProcessor() {
        return this.templateProcessor;
    }

    public PropertyDependencyManager getPropertyDependencyManager() {
        return this.depMgr;
    }

    public Object getProperty(Object object, String property) {
        return this.expLang.getProperty(object, property);
    }

    public void setProperty(Object object, String property, Object value) {
        this.expLang.setProperty(object, property, value);
    }

    public Class getPropertyClass(Object type, String property) {
        return this.expLang.getPropertyClass(type, property);
    }

    public boolean hasMutableProperty(Object object, String expression) {
        return this.expLang.hasMutableProperty(object, expression);
    }

    public boolean isComplete(Object object, String expression) {
        return this.depMgr.isComplete(object, expression);
    }

    public <T> T evaluate(Object object, TemplateExpressionProcessor.TemplateExpression<T> expression) {
        return (T)this.templateProcessor.evaluate(object, expression);
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        this.depMgr.bindListener(object, property, listener);
        return true;
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        this.depMgr.releaseListener(object, property, listener);
        return true;
    }

    public boolean addPropertyChangeListener(Object object, TemplateExpressionProcessor.TemplateExpression expression, PropertyChangeListener listener) {
        this.depMgr.bindListener(object, expression, TEMPLATE_EXPRESSION_LABEL, listener);
        return true;
    }

    public boolean removePropertyChangeListener(Object object, TemplateExpressionProcessor.TemplateExpression expression, PropertyChangeListener listener) {
        this.depMgr.releaseListener(object, expression, TEMPLATE_EXPRESSION_LABEL, listener);
        return true;
    }
}

