/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.progeeks.util.Inspector;
import org.progeeks.util.ObjectFactory;
import org.progeeks.util.TemplateExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableObjectFactory
implements ObjectFactory {
    private Class type;
    private List<Object> arguments = new ArrayList<Object>();
    private boolean applyProperties = true;

    public ImmutableObjectFactory() {
    }

    public ImmutableObjectFactory(Class type, String arg) {
        this.type = type;
        this.arguments.add(arg);
    }

    public ImmutableObjectFactory(Class type, Object[] args) {
        this.type = type;
        this.setArguments(Arrays.asList(args));
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void setApplyProperties(boolean f) {
        this.applyProperties = f;
    }

    public boolean getApplyProperties() {
        return this.applyProperties;
    }

    public void setArguments(List<Object> args) {
        if (this.arguments == args) {
            return;
        }
        this.arguments.clear();
        this.arguments.addAll(args);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public void setArgument(String argument) {
        this.setArguments(Collections.singletonList(argument));
    }

    public String getArgument() {
        if (this.arguments.size() != 1) {
            return null;
        }
        return (String)this.arguments.get(0);
    }

    public void setArgumentsString(String commaDelimited) {
        this.arguments.clear();
        StringTokenizer st = new StringTokenizer(commaDelimited, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.length() == 0) continue;
            this.arguments.add(s);
        }
    }

    @Override
    public Object createObject(Map values) {
        Object[] args = new Object[this.arguments.size()];
        int index = 0;
        for (Object o : this.arguments) {
            if (o instanceof Literal) {
                args[index] = ((Literal)o).getValue();
            } else if (o instanceof TemplateExpressionProcessor.TemplateExpression) {
                Object expVal = TemplateExpressionProcessor.evaluateTemplateExpression((Object)values, (TemplateExpressionProcessor.TemplateExpression)o);
                args[index] = String.valueOf(expVal);
            } else {
                args[index] = values.get(o);
            }
            ++index;
        }
        Object obj = args.length == 1 && args[0] instanceof String ? Inspector.constructFromString((String)args[0], this.type) : Inspector.newInstance(this.type, args);
        if (this.applyProperties) {
            Inspector ins = new Inspector(obj);
            for (Map.Entry e : values.entrySet()) {
                Object key = e.getKey();
                if (this.arguments.contains(key)) continue;
                ins.set((String)key, e.getValue());
            }
        }
        return obj;
    }

    public static class Literal {
        private Object value;

        public Literal() {
        }

        public Literal(Object value) {
            this.value = value;
        }

        public void setValue(Object val) {
            this.value = val;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

