/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class IndentPrintWriter
extends PrintWriter {
    private boolean newLine = true;
    private String separator = System.getProperty("line.separator");
    private String indent = "";
    private String defaultIndent = "    ";
    private boolean indentOverride = false;
    private List<String> indentStack = new LinkedList<String>();

    public IndentPrintWriter(Writer out) {
        super(out);
    }

    public void setDefaultIndent(String s) {
        this.defaultIndent = s;
    }

    public String getDefaultIndent() {
        return this.defaultIndent;
    }

    public void pushIndent() {
        this.pushIndent(this.defaultIndent);
    }

    public void pushIndent(String indent) {
        this.indent = this.indent + indent;
        this.indentStack.add(0, indent);
    }

    public void popIndent() {
        if (this.indentStack.size() == 0) {
            return;
        }
        String i = this.indentStack.remove(0);
        int len = this.indent.length();
        if (len < i.length()) {
            return;
        }
        this.indent = this.indent.substring(0, this.indent.length() - i.length());
    }

    public void setOverrideIndent(boolean override) {
        this.indentOverride = override;
    }

    public void write(int c) {
        if (this.newLine && !this.indentOverride) {
            super.write(this.indent, 0, this.indent.length());
        }
        this.newLine = false;
        super.write(c);
    }

    public void write(char[] buff, int off, int len) {
        if (this.newLine && !this.indentOverride) {
            super.write(this.indent, 0, this.indent.length());
        }
        this.newLine = false;
        super.write(buff, off, len);
    }

    public void write(String s, int off, int len) {
        if (this.newLine && !this.indentOverride) {
            super.write(this.indent, 0, this.indent.length());
        }
        this.newLine = false;
        super.write(s, off, len);
    }

    public void println() {
        super.write(this.separator, 0, this.separator.length());
        this.newLine = true;
    }

    public void endLine() {
        if (!this.newLine) {
            this.println();
        }
        this.newLine = true;
    }

    public boolean isNewLine() {
        return this.newLine;
    }
}

