/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.ArrayUtils;
import org.progeeks.util.EnumUtils;
import org.progeeks.util.InspectionException;
import org.progeeks.util.MethodIndex;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inspector {
    static Log log = Log.getLog(Inspector.class);
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{DateFormat.getDateTimeInstance(3, 1), new SimpleDateFormat("yyyy/MM/dd hh:mm:ss aa zzz"), DateFormat.getDateTimeInstance(3, 3), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aa zzz"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), DateFormat.getDateInstance(3), DateFormat.getDateInstance(), new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy")};
    private static Map<String, Class> primitiveMap = new HashMap<String, Class>();
    protected Object object;
    protected Class type;
    protected MethodIndex index;

    public Inspector() {
    }

    public Inspector(Object object) {
        this.setObject(object);
    }

    public static Class<?> translateFromPrimitive(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }

    public static Map<String, Class> getPrimitiveMap() {
        return primitiveMap;
    }

    public static Object getDefaultPrimitiveValue(Class primitive) {
        if (!primitive.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.equals(primitive)) {
            return new Character('\u0000');
        }
        if (Byte.TYPE.equals(primitive)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(primitive)) {
            return new Short(0);
        }
        if (Integer.TYPE.equals(primitive)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(primitive)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(primitive)) {
            return new Float(0.0f);
        }
        if (Double.TYPE.equals(primitive)) {
            return new Double(0.0);
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }

    protected static Class findClass(String name) throws ClassNotFoundException {
        Thread t = Thread.currentThread();
        Class<?> result = t.getContextClassLoader().loadClass(name);
        if (result != null) {
            return result;
        }
        return Class.forName(name);
    }

    public static Class getClassForName(String name) {
        Class result;
        block9: {
            int split;
            block8: {
                result = primitiveMap.get(name);
                if (result != null) {
                    return result;
                }
                result = ArrayUtils.getArrayClass(name);
                if (result != null) {
                    return result;
                }
                if (name.charAt(0) == '[') {
                    log.warn("Apparent array class name [" + name + "] fell through array class check.");
                }
                try {
                    result = Inspector.findClass(name);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Class search unsuccessful for:" + name, e);
                }
            }
            if (result == null && (split = name.lastIndexOf(46)) >= 0) {
                String p = name.substring(0, split);
                String n = name.substring(split + 1);
                try {
                    result = Inspector.findClass(p + "$" + n);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Class search unsuccessful for:" + p + "$" + n, e);
                }
            }
        }
        return result;
    }

    public static Object newInstance(Class type) {
        if (log.isDebugEnabled()) {
            log.debug("newInstance( " + type.getName() + ")");
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new InspectionException("Error creating new instance of:" + type, e);
        }
    }

    public static Object newInstance(String type) {
        if (log.isDebugEnabled()) {
            log.debug("newInstance( " + type + ")");
        }
        try {
            Class c = Inspector.getClassForName(type);
            if (c == null) {
                throw new InspectionException("Class not found for type:" + type);
            }
            return Inspector.newInstance(c);
        }
        catch (Exception e) {
            throw new InspectionException("Error creating new instance of:" + type, e);
        }
    }

    public static Object newInstance(Class type, Object ... args) {
        Class[] types = null;
        if (args != null) {
            types = new Class[args.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = args[i] == null ? null : args[i].getClass();
            }
        }
        return Inspector.newInstance(type, args, types);
    }

    public static Object newInstance(Class type, Object[] args, Class[] argTypes) {
        if (type == null) {
            throw new InspectionException("Type cannot be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug("newInstance( " + type.getName() + ", " + Arrays.asList(args) + ", " + Arrays.asList(argTypes) + ")");
        }
        try {
            Constructor ctor = Inspector.findConstructor(type, argTypes);
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new InspectionException("Error in newInstance( " + type.getName() + ", " + args[0] + ", " + argTypes[0] + " )", e);
        }
    }

    public static Object newInstance(String className, Object[] args, Class[] argTypes) {
        if (log.isDebugEnabled()) {
            log.debug("newInstance( " + className + ", " + args[0] + ", " + argTypes[0] + ")");
        }
        try {
            Class c = Inspector.getClassForName(className);
            if (c == null) {
                throw new InspectionException("Class not found for type:" + className);
            }
            return Inspector.newInstance(c, args, argTypes);
        }
        catch (Exception e) {
            throw new InspectionException("Error creating new instance of:" + className, e);
        }
    }

    public static boolean hasConstructor(Class type, Class ... argTypes) {
        try {
            Constructor ctor = type.getConstructor(argTypes);
            return ctor != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasOverloadedConstructor(Class type, Class ... argTypes) {
        if (type == null) {
            throw new InspectionException("Type cannot be null.");
        }
        try {
            Inspector.findConstructor(type, argTypes);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static Constructor findConstructor(Class type, Class ... argTypes) throws NoSuchMethodException {
        Constructor ctor = null;
        try {
            ctor = type.getConstructor(argTypes);
            return ctor;
        }
        catch (NoSuchMethodException e) {
            log.debug("Natural constructor not found");
            Constructor<?>[] ctors = type.getConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                Class[] types = ctors[i].getParameterTypes();
                if (log.isDebugEnabled()) {
                    log.debug("checking " + type.getName() + Arrays.asList(types));
                }
                if (types.length != argTypes.length || !Inspector.areTypesCompatible(types, argTypes)) continue;
                return ctors[i];
            }
            throw new NoSuchMethodException("No constructor found for arg list" + Arrays.asList(argTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T constructFromString(String value, Class<T> type) {
        Object array;
        if (String.class.equals(type) || Object.class.equals(type)) {
            return (T)value;
        }
        if (type.isEnum()) {
            return EnumUtils.enumeratedValue(type, value);
        }
        if (Color.class.equals(type)) {
            long l = Long.parseLong(value, 16);
            int i = 0;
            i = l <= Integer.MAX_VALUE ? (int)l : (int)(0xFFFFFFFF00000000L | l);
            boolean hasAlpha = false;
            if (value.length() > 6) {
                hasAlpha = true;
            }
            Color c = new Color(i, hasAlpha);
            return (T)c;
        }
        if (Font.class.equals(type)) {
            return (T)Font.decode(value);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            String l = value.toLowerCase();
            if ("true".equals(l)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equals(l)) {
                return (T)Boolean.FALSE;
            }
            throw new RuntimeException("Error parsing boolean for value:" + value);
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            if (value.length() == 1) {
                return (T)new Character(value.charAt(0));
            }
            Integer n = Inspector.constructFromString(value, Integer.class);
            if (n != null) {
                return (T)new Character((char)n.intValue());
            }
            throw new RuntimeException("Error converting to Character for value:" + value);
        }
        if (Class.class.equals(type)) {
            Class c = Inspector.getClassForName(value);
            if (c == null) {
                throw new RuntimeException("Error resolving class:" + value);
            }
            return (T)c;
        }
        if (File.class.equals(type)) {
            return (T)new File(value);
        }
        if (Timestamp.class.equals(type)) {
            return (T)Timestamp.valueOf(value);
        }
        if (Date.class.equals(type)) {
            if (value.equals("")) {
                log.info("Empty string passed as Date.  Treating as current date/time.");
                return (T)Calendar.getInstance().getTime();
            }
            ParseException lastException = null;
            DateFormat[] dateFormatArray = DATE_FORMATS;
            synchronized (DATE_FORMATS) {
                int i;
                if (log.isDebugEnabled()) {
                    for (i = 0; i < DATE_FORMATS.length; ++i) {
                        try {
                            if (DATE_FORMATS[i] instanceof SimpleDateFormat) {
                                log.debug("Trying:" + ((SimpleDateFormat)DATE_FORMATS[i]).toPattern() + " with value:" + value);
                            } else {
                                log.debug("Trying:" + DATE_FORMATS[i] + " with value:" + value);
                            }
                            log.debug("Got:" + DATE_FORMATS[i].parse(value));
                            continue;
                        }
                        catch (ParseException e) {
                            log.debug("failed to parse.");
                        }
                    }
                }
                for (i = 0; i < DATE_FORMATS.length; ++i) {
                    try {
                        // ** MonitorExit[var3_18] (shouldn't be in output)
                        return (T)DATE_FORMATS[i].parse(value);
                    }
                    catch (ParseException e) {
                        lastException = e;
                        continue;
                    }
                }
                // ** MonitorExit[var3_18] (shouldn't be in output)
                throw new RuntimeException("Error parsing Date for value:" + value, lastException);
            }
        }
        if (type.isArray() && (array = ArrayUtils.constructFromString(value, type)) != null) {
            return (T)array;
        }
        Class<?> alternateType = Inspector.translateFromPrimitive(type);
        if (Inspector.hasConstructor(alternateType, String.class)) {
            Object[] ctorParms = new Object[]{value};
            return (T)Inspector.newInstance(alternateType, ctorParms);
        }
        Constructor<?>[] ctors = alternateType.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] types;
            if (log.isDebugEnabled()) {
                log.debug("ctors[" + i + "] = " + ctors[i]);
            }
            if ((types = ctors[i].getParameterTypes()).length != 1) continue;
            Object arg = null;
            try {
                Class<?> wrapperType = Inspector.translateFromPrimitive(types[0]);
                if (wrapperType != alternateType) {
                    arg = Inspector.constructFromString(value, types[0]);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (arg == null) continue;
            return (T)Inspector.newInstance(alternateType, arg);
        }
        return null;
    }

    public static String encodeAsString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            long argb = (long)(color.getAlpha() << 24 | color.getRGB()) & 0xFFFFFFFFL;
            String s = Long.toHexString(argb);
            if (s.length() < 6) {
                int count = 6 - s.length();
                s = "000000".substring(0, count) + s;
            } else if (s.length() > 8) {
                s = s.substring(0, 8);
            }
            return s;
        }
        if (value instanceof Font) {
            Font f = (Font)value;
            int i = f.getStyle();
            String style = "";
            if ((i & 3) == 3) {
                style = "-BOLDITALIC";
            } else if ((i & 1) == 1) {
                style = "-BOLD";
            } else if ((i & 2) == 2) {
                style = "-ITALIC";
            }
            return f.getName() + style + "-" + f.getSize();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value.getClass().isArray()) {
            return ArrayUtils.encodeAsString(value);
        }
        return String.valueOf(value);
    }

    public static boolean areTypesCompatible(Class[] targets, Class[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (sources[i] == null || Inspector.translateFromPrimitive(targets[i]).isAssignableFrom(sources[i])) continue;
            return false;
        }
        return true;
    }

    public static Object getConstant(String name, Class type) {
        int split = name.lastIndexOf(46);
        if (split > 0) {
            String className = name.substring(0, split);
            name = name.substring(split + 1);
            try {
                Thread t = Thread.currentThread();
                Class<?> c = t.getContextClassLoader().loadClass(className);
                if (c != null) {
                    type = c;
                }
            }
            catch (Exception e) {
                log.info("Class not found for:" + className);
            }
        }
        if (type == null) {
            return null;
        }
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName()) || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                return fields[i].get(null);
            }
            catch (IllegalAccessException e) {
                log.warn("Error getting constant value:" + name, e);
            }
        }
        return null;
    }

    public void setObject(Object object) {
        this.object = object;
        if (object instanceof Class) {
            this.type = (Class)object;
            this.index = MethodIndex.getMethodIndex(this.type, true);
        } else {
            this.type = object.getClass();
            this.index = MethodIndex.getMethodIndex(this.type, false);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void set(String name, Object value) throws InspectionException {
        if (log.isDebugEnabled()) {
            log.debug("set( " + name + ", " + value + "(" + (value == null ? null : value.getClass().getName()) + " )");
        }
        Method m = this.getMutator(name);
        Object[] args = null;
        if (m == null) {
            m = this.getDynamicMutator(name);
            if (m != null) {
                args = new Object[]{name, value};
            }
        } else {
            args = new Object[]{value};
        }
        if (m == null && this.object instanceof Map) {
            ((Map)this.object).put(name, value);
            return;
        }
        if (m == null) {
            throw new InspectionException("Set method not found for property:" + name + " on class:" + this.object.getClass().getName());
        }
        try {
            m.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw new InspectionException("Error calling setter[ set(" + name + ", " + value + ")]", e);
        }
        catch (Exception e) {
            throw new InspectionException("Error calling setter[ set(" + name + ", " + value + ")]", e);
        }
    }

    public void set(String name, Object value, Class type) throws InspectionException {
        Method m;
        if (log.isDebugEnabled()) {
            log.debug("set( " + name + ", " + value + "(" + type + " )");
        }
        if ((m = this.getMutator(name, type)) == null && this.object instanceof Map) {
            ((Map)this.object).put(name, value);
            return;
        }
        if (m == null) {
            throw new InspectionException("Set method not found for property:" + name + " type:" + type + " on class:" + this.object.getClass().getName());
        }
        Object[] args = new Object[]{value};
        try {
            m.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw new InspectionException("Error calling setter[ set(" + name + ", " + value + ")]", e);
        }
        catch (Exception e) {
            throw new InspectionException("Error calling setter[ set(" + name + ", " + value + ")]", e);
        }
    }

    public boolean hasMutator(String name, Class type) {
        if (this.object instanceof Map) {
            return true;
        }
        return this.getMutator(name, type) != null;
    }

    public boolean hasMutator(String name) {
        if (this.object instanceof Map) {
            return true;
        }
        return this.getMutator(name) != null;
    }

    public boolean hasAccessor(String name) {
        if (this.object instanceof Map) {
            return true;
        }
        if (this.type.isArray() && "length".equals(name)) {
            return true;
        }
        return this.getAccessor(name) != null || this.getDynamicAccessor() != null;
    }

    public Object get(String name) {
        if (log.isDebugEnabled()) {
            log.debug("get( " + name + " )");
        }
        if (this.type.isArray() && "length".equals(name)) {
            return new Integer(Array.getLength(this.object));
        }
        Method m = this.getAccessor(name);
        if (m == null && this.object instanceof Map) {
            return ((Map)this.object).get(name);
        }
        Object[] args = null;
        if (m == null && (m = this.getDynamicAccessor()) != null) {
            args = new Object[]{name};
        }
        if (m == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getter method:" + m);
        }
        try {
            return m.invoke(this.object, args);
        }
        catch (Exception e) {
            throw new InspectionException("Error getting value for:" + name, e);
        }
    }

    public Class getType(String name) {
        if (this.type.isArray() && "length".equals(name)) {
            return Integer.class;
        }
        Class result = this.index.getPropertyType(name);
        if (result == null && this.object instanceof Map) {
            return Object.class;
        }
        if (result != null) {
            return result;
        }
        return this.getDynamicType();
    }

    public Class getMutableType(String name) {
        Method m = this.getMutator(name);
        if (m != null) {
            return m.getParameterTypes()[0];
        }
        m = this.getDynamicMutator(name);
        if (m != null) {
            return m.getParameterTypes()[1];
        }
        if (m == null && this.object instanceof Map) {
            return Object.class;
        }
        return null;
    }

    private Method getAccessor(String name) {
        return this.index.getPropertyAccessor(name);
    }

    private Method getDynamicAccessor() {
        return this.getAccessor("");
    }

    public Class getDynamicType() {
        Method m = this.getDynamicAccessor();
        if (m == null) {
            return null;
        }
        return m.getReturnType();
    }

    private Method getMutator(String name) {
        return this.index.getPropertyMutator(name);
    }

    private Method getMutator(String name, Class type) {
        return this.index.getPropertyMutator(name, type);
    }

    private Method getDynamicMutator(String name) {
        if (this.index.getPropertyAccessor(name) != null) {
            return null;
        }
        Method m = this.index.getPropertyMutator("");
        if (m != null) {
            return m;
        }
        return null;
    }

    private Method getDynamicMutator(String name, Class type) {
        return this.getMethod("set", new Class[]{String.class, type});
    }

    private String propertyName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Object callMethod(String name, String param) {
        try {
            Method m = this.getMethod(name, new Class[]{String.class});
            return m.invoke(this.object, param);
        }
        catch (Exception e) {
            throw new InspectionException("Error calling method:" + name, e);
        }
    }

    public Object callMethod(String name, Object ... params) {
        Class[] paramTypes = new Class[params.length];
        for (int index = 0; index < params.length; ++index) {
            if (params[index] == null) continue;
            paramTypes[index] = params[index].getClass();
        }
        try {
            Method m = this.getMethod(name, paramTypes);
            return m.invoke(this.object, params);
        }
        catch (Exception e) {
            throw new InspectionException("Error calling method:" + name, e);
        }
    }

    public boolean hasMethod(String name) {
        return this.getMethod(name, null) != null;
    }

    public boolean hasMethod(String name, Class ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public Object callMethod(String name) {
        try {
            Method m = this.getMethod(name, null);
            if (m == null) {
                throw new InspectionException("Method does not exist:" + name + " on class:" + this.object.getClass());
            }
            return m.invoke(this.object, (Object[])null);
        }
        catch (InspectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InspectionException("Error calling method:" + name, e);
        }
    }

    private Method getMethod(String name, Class[] parms) {
        return this.index.findMethod(name, parms);
    }

    static {
        primitiveMap.put(Byte.TYPE.getName(), Byte.class);
        primitiveMap.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveMap.put(Character.TYPE.getName(), Character.class);
        primitiveMap.put(Float.TYPE.getName(), Float.class);
        primitiveMap.put(Double.TYPE.getName(), Double.class);
        primitiveMap.put(Short.TYPE.getName(), Short.class);
        primitiveMap.put(Integer.TYPE.getName(), Integer.class);
        primitiveMap.put(Long.TYPE.getName(), Long.class);
        primitiveMap = Collections.unmodifiableMap(primitiveMap);
    }
}

