/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends InputStream {
    private InputStream in;
    private long limit;
    private long bytesRead;
    private boolean autoClose;

    public LimitInputStream(InputStream in, long limit, boolean autoClose) {
        this.in = in;
        this.limit = limit;
        this.autoClose = autoClose;
    }

    protected boolean limitReached() throws IOException {
        if (this.bytesRead == this.limit) {
            return true;
        }
        if (this.bytesRead > this.limit) {
            throw new IOException("Stream has been closed.");
        }
        return false;
    }

    public int available() throws IOException {
        int a = this.in.available();
        a = Math.min(a, (int)(this.limit - this.bytesRead));
        return a;
    }

    public void close() throws IOException {
        this.bytesRead = this.limit + 1L;
        if (this.autoClose) {
            this.in.close();
        }
    }

    public int read() throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        int result = this.in.read();
        if (result >= 0) {
            ++this.bytesRead;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.limitReached()) {
            return -1;
        }
        if (this.bytesRead + (long)len > this.limit) {
            len = (int)(this.limit - this.bytesRead);
        }
        if ((result = this.in.read(b, off, len)) > 0) {
            this.bytesRead += (long)result;
        }
        return result;
    }

    public long skip(long n) throws IOException {
        if (this.limitReached()) {
            return -1L;
        }
        long result = this.in.skip(n);
        if (result > 0L) {
            this.bytesRead += result;
        }
        return result;
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported.");
    }
}

