/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

public class NanoTimer {
    private static final double TO_MILLIS = 1.0E-6;
    private long startTime = -1L;
    private long accumulatedTime;
    private long lastDelta;

    public NanoTimer() {
        this(false);
    }

    public NanoTimer(boolean start) {
        if (start) {
            this.start();
        }
    }

    public final void start() {
        this.startTime = System.nanoTime();
    }

    public final void reset() {
        this.accumulatedTime = 0L;
        this.lastDelta = 0L;
    }

    public final long stop() {
        if (this.startTime == -1L) {
            return this.lastDelta;
        }
        this.lastDelta = System.nanoTime() - this.startTime;
        this.accumulatedTime += this.lastDelta;
        this.startTime = -1L;
        return this.lastDelta;
    }

    public final long getSplitTime() {
        long result = this.stop();
        this.start();
        return result;
    }

    public final long getAccumulatedTime() {
        long time = this.accumulatedTime;
        if (this.startTime != -1L) {
            time += System.nanoTime() - this.startTime;
        }
        return time;
    }

    public final double getAccumulatedTimeMillis() {
        return (double)this.getAccumulatedTime() * 1.0E-6;
    }

    public final long getRunTime() {
        if (this.startTime != -1L) {
            return System.nanoTime() - this.startTime;
        }
        return this.lastDelta;
    }

    public final long getLastRunTime() {
        return this.lastDelta;
    }
}

