/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import org.progeeks.util.DefaultProgressReporter;
import org.progeeks.util.ProgressReporter;
import org.progeeks.util.UserRequestHandler;

public class ProgressManager {
    private static ThreadContext threadContext = new ThreadContext();
    private static ReporterFactory defaultFactory = new ReporterFactory();

    public static void setDefaultFactory(ReporterFactory factory) {
        defaultFactory = factory;
    }

    public static void setFactory(ReporterFactory factory) {
        if (factory == null) {
            factory = defaultFactory;
        }
        threadContext.set(factory);
    }

    public static void setUserRequestHandler(UserRequestHandler reqHandler) {
        ProgressManager.setFactory(new UserRequestReporterFactory(reqHandler));
    }

    protected static synchronized ReporterFactory getFactory() {
        return (ReporterFactory)threadContext.get();
    }

    public static ProgressReporter getProgressReporter(String title, String message, int min, int max) {
        ReporterFactory factory = ProgressManager.getFactory();
        return factory.getProgressReporter(title, message, min, max);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadContext
    extends ThreadLocal<ReporterFactory> {
        private ThreadContext() {
        }

        @Override
        protected synchronized ReporterFactory initialValue() {
            return defaultFactory;
        }
    }

    public static class UserRequestReporterFactory
    extends ReporterFactory {
        private UserRequestHandler reqHandler;

        public UserRequestReporterFactory(UserRequestHandler reqHandler) {
            this.reqHandler = reqHandler;
        }

        public ProgressReporter getProgressReporter(String title, String message, int min, int max) {
            return this.reqHandler.requestProgressReporter(title, message, min, max);
        }
    }

    public static class ReporterFactory {
        public ProgressReporter getProgressReporter(String title, String message, int min, int max) {
            DefaultProgressReporter pr = new DefaultProgressReporter();
            pr.setMessage(message);
            pr.setMinimum(min);
            pr.setMaximum(max);
            return pr;
        }
    }
}

