/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.progeeks.util.ProgressReporter;

public class ProgressReporterInputStream
extends FilterInputStream {
    private ProgressReporter reporter;
    private long bytesRead = 0L;

    public ProgressReporterInputStream(InputStream in, ProgressReporter reporter, long estimatedSize) {
        super(in);
        this.reporter = reporter;
        reporter.setMaximum((int)estimatedSize);
        reporter.setProgress((int)this.bytesRead);
    }

    protected void updateBytesRead(long delta) {
        this.bytesRead += delta;
        this.reporter.setProgress((int)this.bytesRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        try {
            int n = super.read();
            return n;
        }
        finally {
            this.updateBytesRead(1L);
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        int read = super.read(b);
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        int read = super.read(b, off, len);
        this.updateBytesRead(read);
        return read;
    }

    public long skip(long n) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        long skipped = super.skip(n);
        this.updateBytesRead(skipped);
        return skipped;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported.");
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.reporter.done();
        super.close();
    }
}

