/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.PropertyPath;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.TemplateExpressionProcessor;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDependencyManager {
    static Log log = Log.getLog();
    private SimpleExpressionLanguage expLang;
    private TemplateExpressionProcessor templateProcessor;
    private Map<DependencyKey, Object> listeners = new HashMap<DependencyKey, Object>();

    public PropertyDependencyManager(TemplateExpressionProcessor tp) {
        this.templateProcessor = tp;
        this.expLang = tp.getExpressionLanguage();
    }

    public TemplateExpressionProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public Set<Object> getSourceObjects() {
        HashSet<Object> result = new HashSet<Object>();
        for (DependencyKey key : this.listeners.keySet()) {
            result.add(key.getSource());
        }
        return result;
    }

    public Set<Object> getWatchedExpressions(Object source) {
        HashSet<Object> result = new HashSet<Object>();
        for (DependencyKey key : this.listeners.keySet()) {
            if (key.getSource() != source) continue;
            result.add(key.getPath());
        }
        return result;
    }

    public List<PropertyChangeListener> getExpressionListeners(Object source, Object expression) {
        ArrayList<PropertyChangeListener> result = new ArrayList<PropertyChangeListener>();
        for (Map.Entry<DependencyKey, Object> e : this.listeners.entrySet()) {
            DependencyKey key = e.getKey();
            if (key.getSource() != source || !expression.equals(key.getPath())) continue;
            ListenerHolder holder = (ListenerHolder)e.getValue();
            result.addAll(holder.listenerList);
        }
        return result;
    }

    protected PathListener getPathListener(Object source, List<SimpleExpressionLanguage.ExpressionElement> path, boolean create) {
        DependencyKey key = new DependencyKey(source, this.expLang.elementsToString(path), null);
        PathListener pl = (PathListener)this.listeners.get(key);
        if (pl == null && create) {
            pl = new PathListener(source, path);
            this.listeners.put(key, pl);
        }
        return pl;
    }

    protected PathListener removePathListener(Object source, List<SimpleExpressionLanguage.ExpressionElement> path) {
        DependencyKey key = new DependencyKey(source, this.expLang.elementsToString(path), null);
        PathListener pl = (PathListener)this.listeners.remove(key);
        return pl;
    }

    protected ExpressionListener getExpressionListener(Object source, TemplateExpressionProcessor.TemplateExpression exp, String id, boolean create) {
        DependencyKey key = new DependencyKey(source, exp, id);
        ExpressionListener el = (ExpressionListener)this.listeners.get(key);
        if (el == null && create) {
            el = new ExpressionListener(source, exp, id);
            this.listeners.put(key, el);
        }
        return el;
    }

    protected ExpressionListener removeExpressionListener(Object source, TemplateExpressionProcessor.TemplateExpression exp, String id) {
        DependencyKey key = new DependencyKey(source, exp, id);
        ExpressionListener pl = (ExpressionListener)this.listeners.remove(key);
        return pl;
    }

    public Object bindListener(Object source, String path, PropertyChangeListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("bindListener( " + source + ", " + path + ", " + listener + ")");
        }
        return this.bindListener(source, this.expLang.parseExpression(path), listener);
    }

    protected Object bindListener(Object source, List<SimpleExpressionLanguage.ExpressionElement> pathElements, PropertyChangeListener listener) {
        PathListener pl = this.getPathListener(source, pathElements, true);
        pl.addListener(listener);
        return pl.path.getValue();
    }

    public boolean isComplete(Object source, String path) {
        PathListener pl = this.getPathListener(source, this.expLang.parseExpression(path), false);
        if (pl == null) {
            return false;
        }
        return pl.isComplete();
    }

    public void releaseListener(Object source, String path, PropertyChangeListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("releaseListener( " + source + ", " + path + ", " + listener + ")");
        }
        this.releaseListener(source, this.expLang.parseExpression(path), listener);
    }

    protected void releaseListener(Object source, List<SimpleExpressionLanguage.ExpressionElement> pathElements, PropertyChangeListener listener) {
        PathListener pl = this.getPathListener(source, pathElements, false);
        if (pl == null) {
            return;
        }
        pl.removeListener(listener);
        if (pl.size() == 0) {
            this.removePathListener(source, pathElements);
            pl.release();
        }
    }

    public Object bindListener(Object source, TemplateExpressionProcessor.TemplateExpression exp, String id, PropertyChangeListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("bindListener( " + source + ", " + exp + ", " + id + ", " + listener + ")");
        }
        ExpressionListener el = this.getExpressionListener(source, exp, id, true);
        el.addListener(listener);
        return el.oldValue;
    }

    public Object releaseListener(Object source, TemplateExpressionProcessor.TemplateExpression exp, String id, PropertyChangeListener listener) {
        ExpressionListener el;
        if (log.isDebugEnabled()) {
            log.debug("releaseListener( " + source + ", " + exp + ", " + id + ", " + listener + ")");
        }
        if ((el = this.getExpressionListener(source, exp, id, false)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("ExpressionListener not found for[" + source + ", " + exp + ", " + id + "]");
            }
            return null;
        }
        el.removeListener(listener);
        if (el.size() == 0) {
            this.removeExpressionListener(source, exp, id);
            el.release();
        }
        return el.oldValue;
    }

    private class DependencyKey {
        private Object source;
        private Object path;
        private Object id;

        public DependencyKey(Object source, Object path, Object id) {
            this.source = source;
            this.path = path;
            this.id = id == null ? "" : id;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getPath() {
            return this.path;
        }

        public Object getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DependencyKey key = (DependencyKey)obj;
            if (this.source != key.source) {
                return false;
            }
            if (!ObjectUtils.areEqual(this.path, key.path)) {
                return false;
            }
            return ObjectUtils.areEqual(this.id, key.id);
        }

        public int hashCode() {
            return this.path.hashCode() + this.id.hashCode();
        }

        public String toString() {
            return "DependencyKey[" + this.source + ", " + this.path + ", " + this.id + "]";
        }
    }

    private class ExpressionListener
    extends ListenerHolder
    implements PropertyChangeListener {
        private Object source;
        private TemplateExpressionProcessor.TemplateExpression expression;
        private String id;
        private Object oldValue;

        public ExpressionListener(Object source, TemplateExpressionProcessor.TemplateExpression exp, String id) {
            this.source = source;
            this.expression = exp;
            this.id = id;
            this.oldValue = PropertyDependencyManager.this.templateProcessor.evaluate(source, this.expression);
            this.connect();
        }

        protected void dumpElements(String indent, List elements) {
            for (Object o : elements) {
                if (o instanceof TemplateExpressionProcessor.ReferenceElement) {
                    System.out.println(indent + o);
                    continue;
                }
                if (o instanceof TemplateExpressionProcessor.NestedExpressionElement) {
                    System.out.println(indent + "NestedExpression:");
                    this.dumpElements(indent + "    ", ((TemplateExpressionProcessor.NestedExpressionElement)o).getElements());
                    continue;
                }
                System.out.println(indent + "String[" + o + "]");
            }
        }

        protected void connect() {
            for (Object o : this.expression.getElements()) {
                if (o instanceof TemplateExpressionProcessor.ReferenceElement) {
                    TemplateExpressionProcessor.ReferenceElement re = (TemplateExpressionProcessor.ReferenceElement)o;
                    PropertyDependencyManager.this.bindListener(this.source, re.getExpression(), (PropertyChangeListener)this);
                    continue;
                }
                if (!(o instanceof TemplateExpressionProcessor.NestedExpressionElement)) continue;
                TemplateExpressionProcessor.NestedExpressionElement nel = (TemplateExpressionProcessor.NestedExpressionElement)o;
                TemplateExpressionProcessor.TemplateExpression e = new TemplateExpressionProcessor.TemplateExpression(nel.getElements());
                Object val = PropertyDependencyManager.this.bindListener(this.source, e, "!nested", this);
                PropertyDependencyManager.this.bindListener(this.source, String.valueOf(val), (PropertyChangeListener)this);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object newValue = PropertyDependencyManager.this.templateProcessor.evaluate(this.source, this.expression);
            if (ObjectUtils.areEqual(this.oldValue, newValue)) {
                return;
            }
            if ("!nested".equals(event.getPropertyName())) {
                PropertyDependencyManager.this.releaseListener(this.source, String.valueOf(event.getOldValue()), (PropertyChangeListener)this);
                PropertyDependencyManager.this.bindListener(this.source, String.valueOf(event.getNewValue()), (PropertyChangeListener)this);
            }
            PropertyChangeEvent e = new PropertyChangeEvent(this.source, this.id, this.oldValue, newValue);
            this.fireChange(e);
            this.oldValue = newValue;
        }

        public void release() {
            for (Object o : this.expression.getElements()) {
                if (o instanceof TemplateExpressionProcessor.ReferenceElement) {
                    TemplateExpressionProcessor.ReferenceElement re = (TemplateExpressionProcessor.ReferenceElement)o;
                    PropertyDependencyManager.this.releaseListener(this.source, re.getExpression(), (PropertyChangeListener)this);
                    continue;
                }
                if (!(o instanceof TemplateExpressionProcessor.NestedExpressionElement)) continue;
                TemplateExpressionProcessor.NestedExpressionElement nel = (TemplateExpressionProcessor.NestedExpressionElement)o;
                TemplateExpressionProcessor.TemplateExpression e = new TemplateExpressionProcessor.TemplateExpression(nel.getElements());
                Object val = PropertyDependencyManager.this.releaseListener(this.source, e, "!nested", this);
                PropertyDependencyManager.this.releaseListener(this.source, String.valueOf(val), (PropertyChangeListener)this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathListener
    extends ListenerHolder
    implements PropertyChangeListener {
        private PropertyPath path;

        public PathListener(Object source, List<SimpleExpressionLanguage.ExpressionElement> elements) {
            this.path = new PropertyPath(source, elements, PropertyDependencyManager.this.expLang.getPropertyAccess());
            this.path.addPropertyChangeListener(this);
        }

        public void release() {
            this.path.removePropertyChangeListener(this);
            this.path.setObject(null);
        }

        public boolean isComplete() {
            if (this.path == null) {
                return false;
            }
            return this.path.isComplete();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.fireChange(e);
        }
    }

    private class ListenerHolder {
        private List<PropertyChangeListener> listenerList = new ArrayList<PropertyChangeListener>();
        private PropertyChangeListener[] array;

        private ListenerHolder() {
        }

        public void addListener(PropertyChangeListener listener) {
            this.listenerList.add(listener);
            this.array = null;
        }

        public void removeListener(PropertyChangeListener listener) {
            this.listenerList.remove(listener);
            this.array = null;
        }

        public int size() {
            return this.listenerList.size();
        }

        public void fireChange(PropertyChangeEvent event) {
            if (this.array == null) {
                this.array = new PropertyChangeListener[this.listenerList.size()];
                this.array = this.listenerList.toArray(this.array);
            }
            if (log.isDebugEnabled()) {
                log.debug("path listener count:" + this.array.length);
            }
            for (int i = 0; i < this.array.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("delivering to:" + this.array[i]);
                }
                this.array[i].propertyChange(event);
            }
        }
    }
}

