/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.ObservableList;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyPath {
    static Log log = Log.getLog();
    private SimpleExpressionLanguage.ExpressionElement[] elements;
    private Object[] values;
    private PropertyAccess access;
    private ChangeListener changeListener;
    private List<PropertyChangeListener> listenerList = new ArrayList<PropertyChangeListener>();
    private PropertyChangeListener[] listeners;
    private String pathId;
    private int firstSilentIndex = 0;

    public PropertyPath(Object root, List<SimpleExpressionLanguage.ExpressionElement> elements, PropertyAccess access) {
        this.elements = new SimpleExpressionLanguage.ExpressionElement[elements.size()];
        this.elements = elements.toArray(this.elements);
        this.values = new Object[elements.size() + 1];
        this.values[0] = root;
        this.access = access;
        this.changeListener = new ChangeListener();
        this.collectValues(-1);
        this.pathId = this.createPathId();
    }

    public boolean isComplete() {
        for (int i = 0; i < this.values.length - 1; ++i) {
            if (this.values[i] != null) continue;
            return false;
        }
        return true;
    }

    protected String createPathId() {
        StringBuffer sb = new StringBuffer();
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (this.elements[i] instanceof SimpleExpressionLanguage.IndexedExpressionElement) {
                sb.insert(0, "[" + ((SimpleExpressionLanguage.IndexedExpressionElement)this.elements[i]).getIndex() + "]");
                continue;
            }
            if (!(this.elements[i] instanceof SimpleExpressionLanguage.NamedExpressionElement)) continue;
            sb.insert(0, ((SimpleExpressionLanguage.NamedExpressionElement)this.elements[i]).getName());
            break;
        }
        return sb.toString();
    }

    protected boolean addElementListener(SimpleExpressionLanguage.ExpressionElement element, Object value) {
        if (element instanceof SimpleExpressionLanguage.IndexedExpressionElement) {
            boolean result = this.access.addPropertyChangeListener(value, this.changeListener);
            if (result && log.isDebugEnabled()) {
                log.debug("added generic listener to:" + value);
            }
            return result;
        }
        if (element instanceof SimpleExpressionLanguage.NamedExpressionElement) {
            boolean result = this.access.addPropertyChangeListener(value, ((SimpleExpressionLanguage.NamedExpressionElement)element).getName(), this.changeListener);
            if (result && log.isDebugEnabled()) {
                log.debug("added [" + ((SimpleExpressionLanguage.NamedExpressionElement)element).getName() + "] listener to:" + value);
            }
            if (!result && value instanceof ObservableList && (result = this.access.addPropertyChangeListener(value, this.changeListener)) && log.isDebugEnabled()) {
                log.debug("added generic listener to:" + value);
            }
            return result;
        }
        throw new RuntimeException("Unhandled expression element:" + element);
    }

    protected boolean removeElementListener(SimpleExpressionLanguage.ExpressionElement element, Object value) {
        if (element instanceof SimpleExpressionLanguage.IndexedExpressionElement) {
            boolean result = this.access.removePropertyChangeListener(value, this.changeListener);
            if (result && log.isDebugEnabled()) {
                log.debug("removed generic listener from:" + value);
            }
            return result;
        }
        if (element instanceof SimpleExpressionLanguage.NamedExpressionElement) {
            boolean result = this.access.removePropertyChangeListener(value, ((SimpleExpressionLanguage.NamedExpressionElement)element).getName(), this.changeListener);
            if (result && log.isDebugEnabled()) {
                log.debug("removed [" + ((SimpleExpressionLanguage.NamedExpressionElement)element).getName() + "] listener from:" + value);
            }
            if (!result && value instanceof ObservableList && (result = this.access.removePropertyChangeListener(value, this.changeListener)) && log.isDebugEnabled()) {
                log.debug("removed generic listener from:" + value);
            }
            return result;
        }
        throw new RuntimeException("Unhandled expression element:" + element);
    }

    protected int findIndex(Object obj) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (obj != this.values[i]) continue;
            return i;
        }
        return -1;
    }

    protected void collectValues(int startIndex) {
        Object oldValue = this.getEnd();
        int start = startIndex;
        if (start < 0) {
            start = 0;
        }
        if (this.firstSilentIndex > start) {
            this.firstSilentIndex = start == 0 && startIndex >= 0 ? 1 : (startIndex == -1 ? 0 : startIndex);
        }
        for (int i = start; i < this.elements.length; ++i) {
            if (this.values[i] == null) {
                this.values[i + 1] = null;
                continue;
            }
            if (i != startIndex) {
                boolean dynamic = this.addElementListener(this.elements[i], this.values[i]);
                if (i == this.firstSilentIndex && dynamic) {
                    ++this.firstSilentIndex;
                }
            }
            this.values[i + 1] = this.elements[i].get(this.access, this.values[i]);
            if (!log.isDebugEnabled()) continue;
            log.debug("values[" + (i + 1) + "] = " + this.values[i + 1]);
        }
        if (log.isDebugEnabled()) {
            log.debug("firstSilentIndex:" + this.firstSilentIndex + "  elements length:" + this.elements.length);
        }
    }

    protected void unwindValues(int index) {
        this.values[this.values.length - 1] = null;
        for (int i = this.elements.length - 1; i > index; --i) {
            if (this.values[i] == null) continue;
            this.removeElementListener(this.elements[i], this.values[i]);
            this.values[i] = null;
        }
    }

    public void setObject(Object obj) {
        Object oldValue = this.getEnd();
        if (this.values[0] != null) {
            this.unwindValues(-1);
        }
        this.values[0] = obj;
        if (obj != null) {
            this.collectValues(-1);
        }
        this.fireChange(oldValue, this.getEnd());
    }

    public Object getObject() {
        return this.values[0];
    }

    public Object getValue() {
        int end = this.values.length - 1;
        if (this.firstSilentIndex < end) {
            if (log.isDebugEnabled()) {
                log.debug("recollecting path values from index:" + this.firstSilentIndex);
            }
            this.unwindValues(this.firstSilentIndex);
            this.collectValues(this.firstSilentIndex);
        }
        return this.getEnd();
    }

    protected Object getEnd() {
        return this.values[this.values.length - 1];
    }

    public void reset() {
        if (this.values[0] == null) {
            return;
        }
        Object oldValue = this.getEnd();
        this.unwindValues(0);
        this.collectValues(0);
        this.fireChange(oldValue, this.getEnd());
    }

    protected void pathChanged(Object src) {
        if (log.isDebugEnabled()) {
            log.debug("pathChanged(" + src + ")");
        }
        Object oldValue = this.getEnd();
        int index = this.findIndex(src);
        this.unwindValues(index);
        this.collectValues(index);
        this.fireChange(oldValue, this.getEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeListener[] getListeners() {
        List<PropertyChangeListener> list = this.listenerList;
        synchronized (list) {
            if (this.listeners == null) {
                this.listeners = new PropertyChangeListener[this.listenerList.size()];
                this.listeners = this.listenerList.toArray(this.listeners);
            }
            return this.listeners;
        }
    }

    protected boolean fireChange(Object oldValue, Object newValue) {
        if (log.isDebugEnabled()) {
            log.debug("fireChange(" + oldValue + "," + newValue + ")");
        }
        if ((oldValue != newValue || !(oldValue instanceof ObservableList)) && ObjectUtils.areEqual(oldValue, newValue)) {
            return false;
        }
        PropertyChangeListener[] array = this.getListeners();
        if (log.isDebugEnabled()) {
            log.debug("  " + array.length + " listeners...");
        }
        if (array.length == 0) {
            return true;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.values[0], this.pathId, oldValue, newValue);
        for (int i = 0; i < array.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("delivering to:" + array[i]);
            }
            array[i].propertyChange(event);
        }
        return true;
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object src = event.getSource();
            if (src == null) {
                throw new RuntimeException("Invalid change event.");
            }
            PropertyPath.this.pathChanged(src);
        }
    }
}

