/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static Pattern INDENT = Pattern.compile("(?m:^)( *).*$");

    public static String detectIndent(String s) {
        if (s.length() == 0) {
            return s;
        }
        Matcher m = INDENT.matcher(s);
        m.find();
        return m.group(1);
    }

    public static String pad(String s, int length) {
        return StringUtils.pad(s, ' ', length);
    }

    public static String pad(String s, char c, int length) {
        if (s == null) {
            return s;
        }
        if (s.length() >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < length) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String prepad(String s, char c, int length) {
        if (s == null) {
            return s;
        }
        if (s.length() >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        length -= s.length();
        while (length > 0) {
            sb.append(c);
            --length;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String join(Iterable i, String delim) {
        StringBuilder sb = new StringBuilder();
        for (Object o : i) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String toHexEncoding(byte[] array) {
        StringBuilder sb = new StringBuilder();
        for (byte b : array) {
            int val = b & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    public static byte[] fromHexEncoding(String s) {
        if (s.length() % 2 != 0) {
            return null;
        }
        byte[] result = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            String part = s.substring(i, i + 2);
            result[i / 2] = (byte)Integer.parseInt(part, 16);
        }
        return result;
    }

    public static String readStringResource(Class c, String resource) throws IOException {
        InputStream in = c.getResourceAsStream(resource);
        if (in == null) {
            throw new RuntimeException("String resource not found:" + resource);
        }
        return StringUtils.readString(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        StringWriter out = new StringWriter();
        try {
            char[] buff = new char[512];
            int bytesRead = 0;
            while ((bytesRead = in.read(buff)) >= 0) {
                out.write(buff, 0, bytesRead);
            }
            String string = out.getBuffer().toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String readFile(File f) throws IOException {
        FileReader r = new FileReader(f);
        return StringUtils.readString(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String s, Writer out) throws IOException {
        PrintWriter w = new PrintWriter(out);
        try {
            w.print(s);
        }
        finally {
            w.close();
        }
    }

    public static void writeFile(String s, File f) throws IOException {
        FileWriter w = new FileWriter(f);
        StringUtils.writeString(s, w);
    }
}

