/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.TypeTransformer;
import org.progeeks.util.el.AbstractDelegatingPropertyAccess;
import org.progeeks.util.log.Log;

public class TypedPropertyAccess
extends AbstractDelegatingPropertyAccess {
    static Log log = Log.getLog(TypedPropertyAccess.class);
    private List<AccessEntry> entryList = new ArrayList<AccessEntry>();
    private AccessEntry[] entries;
    private TypeTransformer typeTransformer;

    public TypedPropertyAccess() {
    }

    public TypedPropertyAccess(PropertyAccess defaultAccess) {
        this.setDefaultPropertyAccess(defaultAccess);
    }

    public boolean acceptsNullSource(String property) {
        return false;
    }

    public void setTypeTransformer(TypeTransformer transformer) {
        this.typeTransformer = transformer;
    }

    public TypeTransformer getTypeTransformer() {
        return this.typeTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerType(Class type, PropertyAccess access) {
        List<AccessEntry> list = this.entryList;
        synchronized (list) {
            this.attachRoot(access);
            this.entryList.add(new AccessEntry(type, access));
            this.entries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessEntry[] getEntries() {
        List<AccessEntry> list = this.entryList;
        synchronized (list) {
            if (this.entries != null) {
                return this.entries;
            }
            this.entries = new AccessEntry[this.entryList.size()];
            this.entries = this.entryList.toArray(this.entries);
            return this.entries;
        }
    }

    protected PropertyAccess getAccess(Object target) {
        AccessEntry[] array = this.getEntries();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].type.isInstance(target)) continue;
            return array[i].access;
        }
        if (log.isTraceEnabled()) {
            log.trace("getAccess(" + (target == null ? "null" : target.getClass().toString()) + ") trying default access.");
        }
        if (this.getDefaultPropertyAccess() == null) {
            throw new RuntimeException("Unhandled type:" + (target == null ? "null" : target.getClass().toString()));
        }
        return this.getDefaultPropertyAccess();
    }

    protected PropertyAccess getAccess(Class type) {
        AccessEntry[] array = this.getEntries();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].type.isAssignableFrom(type)) continue;
            return array[i].access;
        }
        if (log.isTraceEnabled()) {
            log.trace("getAccess(" + type + ") trying default access.");
        }
        if (this.getDefaultPropertyAccess() == null) {
            throw new RuntimeException("Unhandled type:" + type);
        }
        return this.getDefaultPropertyAccess();
    }

    public Object getProperty(Object object, String property) {
        return this.getAccess(object).getProperty(object, property);
    }

    public boolean hasProperty(Object object, String property) {
        return this.getAccess(object).hasProperty(object, property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        return this.getAccess(object).hasMutableProperty(object, property);
    }

    public void setProperty(Object object, String property, Object value) {
        PropertyAccess access = this.getAccess(object);
        if (this.typeTransformer != null && value != null) {
            Class type = access.getPropertyClass(object, property);
            Object v = this.typeTransformer.transformType(value, type);
            if (v == null) {
                throw new RuntimeException("Could not convert property[" + property + "] value:" + value + " to type:" + type);
            }
            value = v;
        }
        access.setProperty(object, property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        return this.getAccess(object).getPropertyClass(object, property);
    }

    public Object getPropertyType(Object type, String property) {
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("Cannot resolve property type from non-java type:" + type);
        }
        return this.getAccess((Class)type).getPropertyClass(type, property);
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getAccess(object).addPropertyChangeListener(object, listener);
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(object).addPropertyChangeListener(object, property, listener);
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getAccess(object).removePropertyChangeListener(object, listener);
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(object).removePropertyChangeListener(object, property, listener);
    }

    protected static class AccessEntry {
        protected Class type;
        protected PropertyAccess access;

        public AccessEntry(Class type, PropertyAccess access) {
            this.type = type;
            this.access = access;
        }
    }
}

