/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.PropertyChangeListener;
import org.progeeks.util.AbstractPropertyAccess;
import org.progeeks.util.Inspector;
import org.progeeks.util.MethodIndex;
import org.progeeks.util.ObservableList;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;

public class BeanPropertyAdapter
extends AbstractPropertyAccess {
    static Log log = Log.getLog(BeanPropertyAdapter.class);
    private static PropertyAccess instance = new BeanPropertyAdapter();

    public static PropertyAccess getInstance() {
        return instance;
    }

    public Object getProperty(Object object, String property) {
        Inspector ins = new Inspector(object);
        return ins.get(property);
    }

    public boolean hasProperty(Object object, String property) {
        Inspector ins = new Inspector(object);
        return ins.hasAccessor(property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        Inspector ins = new Inspector(object);
        return ins.hasMutator(property);
    }

    public void setProperty(Object object, String property, Object value) {
        Inspector ins = new Inspector(object);
        ins.set(property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        Inspector ins = new Inspector(object);
        return ins.getType(property);
    }

    public Object getPropertyType(Object type, String property) {
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("Cannot resolve property type from non-java type:" + type);
        }
        MethodIndex mi = MethodIndex.getMethodIndex((Class)type, false);
        return mi.getPropertyType(property);
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (object instanceof StandardBean) {
            ((StandardBean)object).addPropertyChangeListener(listener);
            return true;
        }
        if (object instanceof ObservableList) {
            ((ObservableList)object).addPropertyChangeListener(listener);
            return true;
        }
        Inspector ins = new Inspector(object);
        Class[] types = new Class[]{PropertyChangeListener.class};
        if (ins.hasMethod("addPropertyChangeListener", types)) {
            if (log.isDebugEnabled()) {
                log.debug("Calling addPropertyChangeListener(" + listener + ") through reflection.");
            }
            Object[] parms = new Object[]{listener};
            ins.callMethod("addPropertyChangeListener", parms);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        if (object instanceof StandardBean) {
            ((StandardBean)object).addPropertyChangeListener(property, listener);
            return true;
        }
        Inspector ins = new Inspector(object);
        Class[] types = new Class[]{String.class, PropertyChangeListener.class};
        if (ins.hasMethod("addPropertyChangeListener", types)) {
            if (log.isDebugEnabled()) {
                log.debug("Calling addPropertyChangeListener(" + property + ", " + listener + ") through reflection.");
            }
            Object[] parms = new Object[]{property, listener};
            ins.callMethod("addPropertyChangeListener", parms);
            return true;
        }
        return false;
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (object instanceof StandardBean) {
            ((StandardBean)object).removePropertyChangeListener(listener);
            return true;
        }
        if (object instanceof ObservableList) {
            ((ObservableList)object).removePropertyChangeListener(listener);
            return true;
        }
        Inspector ins = new Inspector(object);
        Class[] types = new Class[]{PropertyChangeListener.class};
        if (ins.hasMethod("removePropertyChangeListener", types)) {
            if (log.isDebugEnabled()) {
                log.debug("Calling removePropertyChangeListener(" + listener + ") through reflection.");
            }
            Object[] parms = new Object[]{listener};
            ins.callMethod("removePropertyChangeListener", parms);
            return true;
        }
        return false;
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        if (object instanceof StandardBean) {
            ((StandardBean)object).removePropertyChangeListener(property, listener);
            return true;
        }
        Inspector ins = new Inspector(object);
        Class[] types = new Class[]{String.class, PropertyChangeListener.class};
        if (ins.hasMethod("removePropertyChangeListener", types)) {
            if (log.isDebugEnabled()) {
                log.debug("Calling removePropertyChangeListener(" + property + "," + listener + ") through reflection.");
            }
            Object[] parms = new Object[]{property, listener};
            ins.callMethod("removePropertyChangeListener", parms);
            return true;
        }
        return false;
    }
}

