/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.progeeks.util.beans.BeanChangeSupport;
import org.progeeks.util.beans.BeanInspector;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;

public class BeanPropertyPath {
    static Log log = Log.getLog();
    private Object root;
    private String pathExpression;
    private PathElement[] elements;
    private PathReference[] references;
    private PathReference last;
    private Object currentValue;
    private BeanChangeSupport changeSupport = new BeanChangeSupport(this);

    public BeanPropertyPath(String pathExpression) {
        this.pathExpression = pathExpression;
        this.parsePath(pathExpression);
        this.references = new PathReference[this.elements.length];
    }

    public void setObject(Object obj) {
        if (this.root == obj) {
            return;
        }
        this.root = obj;
        this.createReferences(obj, 0);
    }

    public Object getProperty() {
        if (this.last == null) {
            return null;
        }
        return this.last.getValue();
    }

    public void setProperty(Object value) {
        if (this.last == null) {
            throw new RuntimeException("Path is not complete, cannot set end value.");
        }
        this.last.setValue(value);
    }

    public String getPathExpression() {
        return this.pathExpression;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected PathReference createReference(PathElement element, Object obj) {
        if (element instanceof PropertyElement) {
            return new PropertyReference(((PropertyElement)element).getName(), obj);
        }
        return null;
    }

    protected void createReferences(Object obj, int start) {
        int i;
        for (i = start; i < this.elements.length; ++i) {
            if (this.references[i] != null) {
                this.references[i].release();
            }
            this.references[i] = null;
        }
        for (i = start; i < this.elements.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Value:" + obj);
            }
            if (obj == null) break;
            this.references[i] = this.createReference(this.elements[i], obj);
            if (log.isDebugEnabled()) {
                log.debug("element:" + this.elements[i] + "   reference:" + this.references[i]);
            }
            if (this.references[i] == null) break;
            obj = this.references[i].getValue();
        }
        this.last = this.references[this.references.length - 1];
        this.currentValue = this.getProperty();
    }

    protected void referenceChanged(PathReference reference) {
        Object old = this.currentValue;
        if (reference != this.last) {
            int index;
            for (index = 0; index < this.references.length && this.references[index] != reference; ++index) {
            }
            if (index == this.references.length) {
                throw new RuntimeException("PathReference not found in path array.");
            }
            this.createReferences(reference.getValue(), index + 1);
        } else {
            this.currentValue = this.getProperty();
        }
        this.changeSupport.firePropertyChange(this.pathExpression, old, this.currentValue);
    }

    protected void parsePath(String pathExpression) {
        ArrayList<PropertyElement> els = new ArrayList<PropertyElement>();
        StringTokenizer st = new StringTokenizer(pathExpression, ".");
        while (st.hasMoreTokens()) {
            els.add(new PropertyElement(st.nextToken()));
        }
        this.elements = new PathElement[els.size()];
        this.elements = els.toArray(this.elements);
    }

    protected class PropertyReference
    implements PathReference,
    PropertyChangeListener {
        private Object bean;
        private BeanInspector beanIns;
        private String name;
        private boolean listenerEnabled = false;

        public PropertyReference(String name, Object bean) {
            this.name = name;
            this.bean = bean;
            this.beanIns = BeanInspector.getInspector(bean.getClass());
            if (bean instanceof StandardBean) {
                ((StandardBean)bean).addPropertyChangeListener(name, this);
                this.listenerEnabled = true;
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!this.listenerEnabled) {
                return;
            }
            BeanPropertyPath.this.referenceChanged(this);
        }

        public void release() {
            this.listenerEnabled = false;
            if (this.bean instanceof StandardBean) {
                ((StandardBean)this.bean).removePropertyChangeListener(this.name, this);
            }
        }

        public Object getValue() {
            if (this.bean instanceof Map && this.beanIns.getDescriptor(this.name) == null) {
                return ((Map)this.bean).get(this.name);
            }
            return this.beanIns.getProperty(this.bean, this.name);
        }

        public void setValue(Object value) {
            if (this.bean instanceof Map && this.beanIns.getDescriptor(this.name) == null) {
                ((Map)this.bean).put(this.name, value);
                return;
            }
            this.beanIns.setProperty(this.bean, this.name, value);
        }

        public String toString() {
            return "PropertyReference[" + this.bean + "-> " + this.name + " = " + this.getValue() + "]";
        }
    }

    protected static interface PathReference {
        public Object getValue();

        public void setValue(Object var1);

        public void release();
    }

    protected static class PropertyElement
    implements PathElement {
        private String name;

        public PropertyElement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "PropertyElement[" + this.name + "]";
        }
    }

    protected static interface PathElement {
    }
}

