/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.Collection;
import org.progeeks.util.Inspector;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.TypeTransformer;
import org.progeeks.util.TypedPropertyAccess;
import org.progeeks.util.beans.BeanPropertyAdapter;
import org.progeeks.util.el.CipherTransform;
import org.progeeks.util.el.CollectionExpanderAccess;
import org.progeeks.util.el.DefaultValueTransform;
import org.progeeks.util.el.FormatTransform;
import org.progeeks.util.el.GlobalAccess;
import org.progeeks.util.el.JoinTransform;
import org.progeeks.util.el.LabeledPropertyAccess;
import org.progeeks.util.el.PatternedTransformingAccess;
import org.progeeks.util.el.PrefixedPropertyAccess;
import org.progeeks.util.el.XmlEscapingTransform;
import org.progeeks.util.el.XmlPropertyAccess;
import org.w3c.dom.Node;

public class DefaultAccessStack
extends PrefixedPropertyAccess {
    private char prefix;
    private TypedPropertyAccess types = new TypedPropertyAccess(BeanPropertyAdapter.getInstance());
    private LabeledPropertyAccess funcs = new LabeledPropertyAccess();
    private GlobalAccess globals = new GlobalAccess(this.funcs);

    public DefaultAccessStack() {
        this('%');
    }

    public DefaultAccessStack(char prefix) {
        this.setDefaultPropertyAccess(this.types);
        this.prefix = prefix;
        this.registerDelegate(prefix, (PropertyAccess)this.globals);
    }

    public static DefaultAccessStack createFullStack() {
        DefaultAccessStack stack = new DefaultAccessStack();
        stack.registerDelegate(new CipherTransform());
        stack.registerDelegate(new DefaultValueTransform());
        stack.registerDelegate(new FormatTransform());
        stack.registerDelegate(new JoinTransform());
        stack.registerDelegate(new XmlEscapingTransform());
        stack.registerType(Node.class, new XmlPropertyAccess());
        stack.registerType(Collection.class, new CollectionExpanderAccess());
        Class metaObjectClass = Inspector.getClassForName("org.progeeks.meta.MetaObject");
        if (metaObjectClass != null) {
            Class adapterClass = Inspector.getClassForName("org.progeeks.meta.util.PropertyAdapter");
            Inspector ins = new Inspector(adapterClass);
            PropertyAccess moAdapter = (PropertyAccess)ins.get("instance");
            stack.registerType(metaObjectClass, moAdapter);
        }
        return stack;
    }

    public void setDefaultPropertyAccess(PropertyAccess defaultAccess) {
        if (!(defaultAccess instanceof TypedPropertyAccess)) {
            throw new IllegalArgumentException("Default access must be a TypedPropertyAccess or subclass.");
        }
        this.types = (TypedPropertyAccess)defaultAccess;
        super.setDefaultPropertyAccess(this.types);
    }

    public void setTypeTransformer(TypeTransformer transformer) {
        this.types.setTypeTransformer(transformer);
    }

    public TypeTransformer getTypeTransformer() {
        return this.types.getTypeTransformer();
    }

    public void registerType(Class type, PropertyAccess access) {
        this.types.registerType(type, access);
    }

    public void registerDelegate(String pattern, PropertyAccess access) {
        this.funcs.registerDelegate(pattern, access);
    }

    public void registerDelegate(PatternedTransformingAccess access) {
        this.funcs.registerDelegate(access.getPattern(), access);
    }

    public void setGlobal(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (key.length() == 0 || key.charAt(0) != this.prefix) {
            throw new IllegalArgumentException("Key must start with the configured prefix character:" + this.prefix);
        }
        this.globals.setGlobal(key, value);
    }

    public boolean clearGlobal(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (key.length() == 0 || key.charAt(0) != this.prefix) {
            throw new IllegalArgumentException("Key must start with the configured prefix character:" + this.prefix);
        }
        return this.globals.clearGlobal(key);
    }
}

