/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.el.AbstractTransformingAccess;
import org.progeeks.util.el.PatternedTransformingAccess;

public class DefaultValueTransform
extends AbstractTransformingAccess
implements PatternedTransformingAccess {
    public static final String NULL_PATTERN = ".nullDefault\\((.*)\\)";
    public static final String EMPTY_PATTERN = ".emptyDefault\\((.*)\\)";
    private static Pattern nullPattern = Pattern.compile(".nullDefault\\((.*)\\)");
    private static Pattern emptyPattern = Pattern.compile(".emptyDefault\\((.*)\\)");

    public boolean acceptsNullSource(String property) {
        return true;
    }

    public String getPattern() {
        return ".nullDefault\\((.*)\\)|.emptyDefault\\((.*)\\)";
    }

    public Object getProperty(Object object, String property) {
        Matcher m = emptyPattern.matcher(property);
        if (m.matches()) {
            if (this.isEmpty(object)) {
                return this.convertDefault(m.group(1), object);
            }
            return object;
        }
        m = nullPattern.matcher(property);
        if (m.matches()) {
            if (object == null) {
                return this.convertDefault(m.group(1), object);
            }
            return object;
        }
        throw new IllegalArgumentException("Could not parse argument[" + property + "]");
    }

    protected boolean isEmpty(Object object) {
        return object == null || object instanceof CharSequence && ((CharSequence)object).length() == 0 || object instanceof Collection && ((Collection)object).size() == 0 || object instanceof Map && ((Map)object).size() == 0;
    }

    protected Object convertDefault(String defaultValue, Object originalValue) {
        return defaultValue;
    }
}

