/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.beans.PropertyChangeListener;
import org.progeeks.util.ObservableMap;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.el.AbstractDelegatingPropertyAccess;
import org.progeeks.util.log.Log;

public class GlobalAccess
extends AbstractDelegatingPropertyAccess {
    static Log log = Log.getLog();
    private ObservableMap<String, Object> map = new ObservableMap();

    public GlobalAccess() {
    }

    public GlobalAccess(PropertyAccess defaultAccess) {
        this.setDefaultPropertyAccess(defaultAccess);
    }

    public void setGlobal(String key, Object value) {
        this.map.put(key, value);
    }

    public boolean clearGlobal(String key) {
        return this.map.remove(key) != null;
    }

    public Object getProperty(Object object, String property) {
        if (this.map.containsKey(property)) {
            return this.map.get(property);
        }
        if (log.isTraceEnabled()) {
            log.trace("getProperty(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().getProperty(object, property);
    }

    public boolean hasProperty(Object object, String property) {
        if (this.map.containsKey(property)) {
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("hasProperty(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().hasProperty(object, property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        if (this.map.containsKey(property)) {
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("hasMutableProperty(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().hasMutableProperty(object, property);
    }

    public boolean acceptsNullSource(String property) {
        if (this.map.containsKey(property)) {
            return true;
        }
        return this.getDefaultPropertyAccess().acceptsNullSource(property);
    }

    public void setProperty(Object object, String property, Object value) {
        if (this.map.containsKey(property)) {
            this.map.put(property, value);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("setProperty(" + property + ") trying default access.");
        }
        this.getDefaultPropertyAccess().setProperty(object, property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        if (this.map.containsKey(property)) {
            return Object.class;
        }
        if (log.isTraceEnabled()) {
            log.trace("getPropertyClass(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().getPropertyClass(object, property);
    }

    public Object getPropertyType(Object type, String property) {
        if (this.map.containsKey(property)) {
            return Object.class;
        }
        if (log.isTraceEnabled()) {
            log.trace("getPropertyType(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().getPropertyType(type, property);
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().addPropertyChangeListener(object, listener);
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        if (this.map.containsKey(property)) {
            this.map.addPropertyChangeListener(property, listener);
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("addPropertyChangeListener(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().addPropertyChangeListener(object, property, listener);
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().removePropertyChangeListener(object, listener);
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        if (this.map.containsKey(property)) {
            this.map.removePropertyChangeListener(property, listener);
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("removePropertyChangeListener(" + property + ") trying default access.");
        }
        return this.getDefaultPropertyAccess().removePropertyChangeListener(object, property, listener);
    }
}

