/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.el.AbstractDelegatingPropertyAccess;
import org.progeeks.util.log.Log;

public class LabeledPropertyAccess
extends AbstractDelegatingPropertyAccess {
    static Log log = Log.getLog();
    private List<AccessEntry> entryList = new ArrayList<AccessEntry>();
    private AccessEntry[] entries;

    public LabeledPropertyAccess() {
    }

    public LabeledPropertyAccess(PropertyAccess defaultAccess) {
        this.setDefaultPropertyAccess(defaultAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDelegate(String pattern, PropertyAccess access) {
        List<AccessEntry> list = this.entryList;
        synchronized (list) {
            this.attachRoot(access);
            this.entryList.add(new AccessEntry(pattern, access));
            this.entries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessEntry[] getEntries() {
        List<AccessEntry> list = this.entryList;
        synchronized (list) {
            if (this.entries != null) {
                return this.entries;
            }
            this.entries = new AccessEntry[this.entryList.size()];
            this.entries = this.entryList.toArray(this.entries);
            return this.entries;
        }
    }

    protected PropertyAccess getAccess(String property) {
        AccessEntry[] array = this.getEntries();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].isMatch(property)) continue;
            return array[i].access;
        }
        if (log.isTraceEnabled()) {
            log.trace("getAccess(" + property + ") trying default access.");
        }
        if (this.getDefaultPropertyAccess() == null) {
            throw new RuntimeException("Unhandled property:" + property);
        }
        return this.getDefaultPropertyAccess();
    }

    public Object getProperty(Object object, String property) {
        return this.getAccess(property).getProperty(object, property);
    }

    public boolean hasProperty(Object object, String property) {
        return this.getAccess(property).hasProperty(object, property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        return this.getAccess(property).hasMutableProperty(object, property);
    }

    public boolean acceptsNullSource(String property) {
        return true;
    }

    public void setProperty(Object object, String property, Object value) {
        PropertyAccess access = this.getAccess(property);
        access.setProperty(object, property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        return this.getAccess(property).getPropertyClass(object, property);
    }

    public Object getPropertyType(Object type, String property) {
        return this.getAccess(property).getPropertyType(type, property);
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().addPropertyChangeListener(object, listener);
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(property).addPropertyChangeListener(object, property, listener);
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().removePropertyChangeListener(object, listener);
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(property).removePropertyChangeListener(object, property, listener);
    }

    protected static class AccessEntry {
        protected Pattern pattern;
        protected PropertyAccess access;

        public AccessEntry(String s, PropertyAccess access) {
            this.pattern = Pattern.compile(s);
            this.access = access;
        }

        public boolean isMatch(String property) {
            Matcher m = this.pattern.matcher(property);
            boolean result = m.matches();
            if (log.isTraceEnabled()) {
                log.trace("isMatch(" + property + ")  pattern:" + this.pattern.pattern() + " = " + result);
            }
            return result;
        }
    }
}

