/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.TypeTransformer;
import org.progeeks.util.el.AbstractDelegatingPropertyAccess;
import org.progeeks.util.log.Log;

public class PrefixedPropertyAccess
extends AbstractDelegatingPropertyAccess {
    static Log log = Log.getLog();
    private Map<Character, PropertyAccess> redirects = new HashMap<Character, PropertyAccess>();
    private TypeTransformer typeTransformer;

    public PrefixedPropertyAccess() {
    }

    public PrefixedPropertyAccess(PropertyAccess defaultAccess) {
        this.setDefaultPropertyAccess(defaultAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDelegate(char marker, PropertyAccess access) {
        Map<Character, PropertyAccess> map = this.redirects;
        synchronized (map) {
            this.attachRoot(access);
            this.redirects.put(Character.valueOf(marker), access);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyAccess getAccess(String property) {
        if (property.length() == 0) {
            return this.getDefaultPropertyAccess();
        }
        char marker = property.charAt(0);
        Map<Character, PropertyAccess> map = this.redirects;
        synchronized (map) {
            PropertyAccess result = this.redirects.get(Character.valueOf(marker));
            if (log.isTraceEnabled()) {
                log.trace("getAccess(" + property + ") found:" + result);
            }
            if (result != null) {
                return result;
            }
            if (this.getDefaultPropertyAccess() == null) {
                throw new RuntimeException("Unhandled property:" + property);
            }
            return this.getDefaultPropertyAccess();
        }
    }

    public Object getProperty(Object object, String property) {
        return this.getAccess(property).getProperty(object, property);
    }

    public boolean hasProperty(Object object, String property) {
        return this.getAccess(property).hasProperty(object, property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        return this.getAccess(property).hasMutableProperty(object, property);
    }

    public boolean acceptsNullSource(String property) {
        return this.getAccess(property).acceptsNullSource(property);
    }

    public void setProperty(Object object, String property, Object value) {
        PropertyAccess access = this.getAccess(property);
        access.setProperty(object, property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        return this.getAccess(property).getPropertyClass(object, property);
    }

    public Object getPropertyType(Object type, String property) {
        return this.getAccess(property).getPropertyType(type, property);
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().addPropertyChangeListener(object, listener);
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(property).addPropertyChangeListener(object, property, listener);
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        return this.getDefaultPropertyAccess().removePropertyChangeListener(object, listener);
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return this.getAccess(property).removePropertyChangeListener(object, property, listener);
    }
}

