/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.log;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.progeeks.util.log.EventAppender;
import org.progeeks.util.log.LegacyTraceLevel;
import org.progeeks.util.log.LogLevel;
import org.progeeks.util.log.LogListener;

public class Log {
    public static final String KEY_LOG_CONFIG = "log.config";
    public static final String DEFAULT_CONFIG = "log.config";
    private String className = "org.progeeks.util.log.Log";
    private Logger logger;
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        String configFile = System.getProperty("log.config");
        if (configFile == null && new File("log.config").exists()) {
            configFile = "log.config";
        } else if ("null".equalsIgnoreCase(configFile)) {
            configFile = null;
        }
        if (configFile != null) {
            if (configFile.endsWith(".xml")) {
                DOMConfigurator.configure((String)configFile);
            } else {
                PropertyConfigurator.configure((String)configFile);
            }
        } else {
            Properties props = Log.getDefaultConfiguration();
            if (props != null) {
                PropertyConfigurator.configure((Properties)props);
            } else {
                BasicConfigurator.configure();
            }
        }
    }

    public static synchronized void initialize(URL config) {
        if (config == null) {
            BasicConfigurator.configure();
            return;
        }
        if (config.getFile().endsWith(".xml")) {
            DOMConfigurator.configure((URL)config);
        } else {
            PropertyConfigurator.configure((URL)config);
        }
    }

    private static Properties getDefaultConfiguration() {
        try {
            Class<?> configClass = Class.forName("Configuration");
            Method m = configClass.getMethod("loadProperties", String.class);
            return (Properties)m.invoke(null, "log.config");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Log getLog(String categoryName) {
        return new Log(Logger.getLogger((String)categoryName));
    }

    public static Log getLog(Class c) {
        return Log.getLog(c.getName());
    }

    public static Log getLog() {
        return Log.getLog(new Exception().getStackTrace()[1].getClassName());
    }

    public static Log getRootLog() {
        return new Log(Logger.getRootLogger());
    }

    public static boolean exists(String category) {
        return LogManager.exists((String)category) != null;
    }

    public static boolean exists(Class c) {
        return Log.exists(c.getName());
    }

    public static Iterator categoryNames() {
        return new CategoryNameIterator(LogManager.getCurrentLoggers());
    }

    public static void addLogListener(LogListener listener, LogLevel level) {
        Log.addLogListener(listener, Logger.getRootLogger(), level);
    }

    public static void addLogListener(LogListener listener, String category, LogLevel level) {
        Log.addLogListener(listener, Logger.getLogger((String)category), level);
    }

    public static void addLogListener(LogListener listener, Class c, LogLevel level) {
        Log.addLogListener(listener, c.getName(), level);
    }

    private static void addLogListener(LogListener listener, Logger c, LogLevel level) {
        c.addAppender((Appender)new EventAppender(level, listener));
    }

    public static void push(String context) {
        NDC.push((String)context);
    }

    public static String pop() {
        return NDC.pop();
    }

    public static void end() {
        NDC.remove();
    }

    private Log(Logger logger) {
        this.logger = logger;
    }

    public String getCategoryName() {
        return this.logger.getName();
    }

    public void setLogLevel(LogLevel level) {
        if (level == null) {
            this.logger.setLevel(null);
            return;
        }
        Level l = Level.toLevel((int)level.toInt());
        this.logger.setLevel(l);
    }

    public LogLevel getLogLevel() {
        Level l = this.logger.getLevel();
        if (l == null) {
            return null;
        }
        return LogLevel.toLevel(l.toInt());
    }

    public LogLevel getEffectiveLogLevel() {
        Level l = this.logger.getEffectiveLevel();
        return LogLevel.toLevel(l.toInt());
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public void trace(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)LegacyTraceLevel.TRACE, message, t);
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)Level.DEBUG, message, t);
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)Level.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)Level.FATAL, message, t);
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)Level.INFO, message, t);
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        this.logger.log(this.className, (Priority)Level.WARN, message, t);
    }

    public void log(Object message, LogLevel level) {
        this.log(message, level, null);
    }

    public void log(Object message, LogLevel level, Throwable t) {
        this.logger.log(this.className, (Priority)Level.toLevel((int)level.toInt()), message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)LegacyTraceLevel.TRACE);
    }

    private static class CategoryNameIterator
    implements Iterator {
        private Enumeration en;

        public CategoryNameIterator(Enumeration en) {
            this.en = en;
        }

        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        public Object next() {
            Logger logger = (Logger)this.en.nextElement();
            return logger.getName();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }
    }
}

