/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.progeeks.util.FocusedContext;
import org.progeeks.util.MultiFocusedContext;
import org.progeeks.util.ViewContext;
import org.progeeks.util.swing.AbstractContextAction;

public abstract class AbstractFocusedContextAction
extends AbstractContextAction {
    private FocusedContextListener contextListener;

    protected AbstractFocusedContextAction() {
    }

    protected AbstractFocusedContextAction(String name) {
        super(name);
    }

    protected AbstractFocusedContextAction(String name, Icon icon) {
        super(name, icon);
    }

    protected abstract void focusChanged();

    protected Object getFocus() {
        ViewContext context = this.getViewContext();
        if (context instanceof FocusedContext) {
            return ((FocusedContext)context).getFocus();
        }
        return null;
    }

    protected List getFocusedObjects() {
        ViewContext context = this.getViewContext();
        if (context instanceof MultiFocusedContext) {
            return ((MultiFocusedContext)context).getFocusedObjects();
        }
        Object focus = this.getFocus();
        if (focus == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(focus);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractFocusedContextAction clone = (AbstractFocusedContextAction)super.clone();
        clone.contextListener = null;
        return clone;
    }

    public void setViewContext(ViewContext context) {
        ViewContext old = this.getViewContext();
        if (old instanceof FocusedContext && this.contextListener != null) {
            if (old instanceof MultiFocusedContext) {
                ((MultiFocusedContext)old).removePropertyChangeListener("focusedObjects", this.contextListener);
            } else {
                ((FocusedContext)old).removePropertyChangeListener("focus", this.contextListener);
            }
        }
        super.setViewContext(context);
        if (context instanceof FocusedContext) {
            if (this.contextListener == null) {
                this.contextListener = new FocusedContextListener();
            }
            if (context instanceof MultiFocusedContext) {
                context.addPropertyChangeListener("focusedObjects", this.contextListener);
            } else {
                context.addPropertyChangeListener("focus", this.contextListener);
            }
        }
        this.focusChanged();
    }

    private class FocusedContextListener
    implements PropertyChangeListener {
        private FocusedContextListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractFocusedContextAction.this.focusChanged();
        }
    }
}

