/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private static final TreeModelListener[] EMPTY = new TreeModelListener[0];

    protected AbstractTreeModel() {
    }

    public List getChildList(Object parent) {
        throw new UnsupportedOperationException();
    }

    public Object getChild(Object parent, int index) {
        List list = this.getChildList(parent);
        if (list == null) {
            return null;
        }
        return list.get(index);
    }

    public int getChildCount(Object parent) {
        return this.getChildList(parent).size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        List list = this.getChildList(parent);
        return list.indexOf(child);
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, path.pathByAddingChild(newValue)));
    }

    protected TreeModelListener[] getListeners() {
        if (this.listeners.size() == 0) {
            return EMPTY;
        }
        TreeModelListener[] list = new TreeModelListener[this.listeners.size()];
        return this.listeners.toArray(list);
    }

    protected void fireTreeNodesChanged(TreeModelEvent event) {
        TreeModelListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            list[i].treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent event) {
        TreeModelListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            list[i].treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent event) {
        TreeModelListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            list[i].treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        TreeModelListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            list[i].treeStructureChanged(event);
        }
    }
}

