/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.swing.ActionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionListGroup
extends ActionList {
    static final long serialVersionUID = 1L;
    private List<Object> group = new ArrayList<Object>();
    private List<ListRangeTracker> ranges = new ArrayList<ListRangeTracker>();
    private int internalMod = 0;

    public ActionListGroup() {
    }

    public ActionListGroup(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInlineList(ActionList list) {
        ++this.internalMod;
        try {
            this.group.add(list);
            int index = this.size();
            ListRangeTracker lrt = new ListRangeTracker(index, list);
            this.ranges.add(lrt);
            this.addAll(list);
            this.adjustRanges(index, list.size(), this.ranges.indexOf(lrt));
        }
        finally {
            --this.internalMod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInlineList(int index, ActionList list) {
        int listIndex = 0;
        for (ListRangeTracker lrt : this.ranges) {
            if (index > lrt.getStartIndex() && listIndex < lrt.getStartIndex() + lrt.getSize()) {
                throw new IllegalArgumentException("Cannot add a list in the middle of another list: " + lrt.getList());
            }
            if (lrt.getStartIndex() >= index) break;
            ++listIndex;
        }
        ++this.internalMod;
        try {
            this.group.add(listIndex, list);
            ListRangeTracker lrt = new ListRangeTracker(index, list);
            this.ranges.add(listIndex, lrt);
            this.addAll(lrt.getInsertIndex(), list);
            this.adjustRanges(index, list.size(), this.ranges.indexOf(lrt));
        }
        finally {
            --this.internalMod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInlineList(ActionList list) {
        int index = this.group.indexOf(list);
        if (index < 0) {
            return false;
        }
        ++this.internalMod;
        try {
            this.group.remove(index);
            ListRangeTracker lrt = this.ranges.remove(index);
            lrt.clear();
            for (int i = lrt.getStartIndex(); i < lrt.getStartIndex() + lrt.getSize(); ++i) {
                this.remove(i);
            }
            this.adjustRanges(lrt.getStartIndex(), -list.size(), index);
        }
        finally {
            --this.internalMod;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ++this.internalMod;
        try {
            for (ListRangeTracker lrt : this.ranges) {
                lrt.clear();
            }
            this.group.clear();
            this.ranges.clear();
            super.clear();
        }
        finally {
            --this.internalMod;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public void fireElementsInserted(int first, int last, List<Object> original) {
        ListRangeTracker lrt;
        if (this.internalMod == 0 && (lrt = this.getRange(first, false)) != null) {
            throw new RuntimeException("Cannot add an element to an inlined list.  Use the sublist.");
        }
        super.fireElementsInserted(first, last, original);
        if (this.internalMod == 0) {
            this.adjustRanges(first, last - first + 1);
        }
    }

    @Override
    public void fireElementsRemoved(int first, int last, List<Object> original) {
        ListRangeTracker lrt;
        if (this.internalMod == 0 && (lrt = this.getRange(first, true)) != null) {
            throw new RuntimeException("Cannot remove an element from an inlined list.  Use the sublist.");
        }
        super.fireElementsRemoved(first, last, original);
        if (this.internalMod == 0) {
            this.adjustRanges(first, first - last - 1);
        }
    }

    private ListRangeTracker getRange(int index, boolean startInclusive) {
        for (ListRangeTracker lrt : this.ranges) {
            if (!(startInclusive ? index >= lrt.getStartIndex() && index < lrt.getStartIndex() + lrt.getSize() : index > lrt.getStartIndex() && index < lrt.getStartIndex() + lrt.getSize())) continue;
            return lrt;
        }
        return null;
    }

    private void adjustRanges(int baseIndex, int delta) {
        for (ListRangeTracker lrt : this.ranges) {
            if (lrt.getStartIndex() < baseIndex) continue;
            lrt.adjustStartIndex(delta);
        }
        this.recalculateSeparators();
    }

    private void adjustRanges(int baseIndex, int delta, int excludeIndex) {
        int index = 0;
        for (ListRangeTracker lrt : this.ranges) {
            if (index > excludeIndex && lrt.getStartIndex() >= baseIndex) {
                lrt.adjustStartIndex(delta);
            }
            ++index;
        }
        this.recalculateSeparators();
    }

    private void recalculateSeparators() {
        for (ListRangeTracker lrt : this.ranges) {
            lrt.recalculateSeparator();
        }
    }

    public static void printList(ActionList list, String indent) {
        if (list == null) {
            System.out.println(indent + "----------------");
            return;
        }
        System.out.println(indent + "Name:" + list.getValue("Name"));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ActionListGroup.printList((ActionList)i.next(), "  ");
        }
    }

    public static void main(String[] args) {
        ActionList list1 = new ActionList("foo");
        list1.add(new ActionList("Test1"));
        list1.add(new ActionList("Test2"));
        ActionList list2 = new ActionList("bar");
        list2.add(new ActionList("TestA"));
        list2.add(new ActionList("TestB"));
        list2.add(new ActionList("TestC"));
        ActionList list3 = new ActionList("baz");
        list3.add(new ActionList("Test3"));
        list3.add(new ActionList("Test4"));
        list3.add(new ActionList("Test5"));
        list3.add(new ActionList("Test6"));
        ActionListGroup group1 = new ActionListGroup("root1");
        group1.addInlineList(list1);
        group1.addInlineList(list2);
        group1.add((Object)null);
        group1.add(new ActionList("End Test"));
        ActionListGroup.printList(group1, "");
        System.out.println();
        ActionListGroup group2 = new ActionListGroup("root2");
        group2.add(new ActionList("Begin Test"));
        group2.addInlineList(list3);
        group2.addInlineList(list1);
        group2.addInlineList(1, list2);
        ActionListGroup.printList(group2, "");
        System.out.println();
        System.out.println("Adding item to list 2.");
        list2.add(new ActionList("TestD"));
        ActionListGroup.printList(group1, "");
        System.out.println();
        ActionListGroup.printList(group2, "");
        System.out.println();
        System.out.println("Adding item to root1 index 0.");
        group1.add(0, new ActionList("Begin Insert"));
        ActionListGroup.printList(group1, "");
    }

    private class ListRangeTracker
    implements PropertyChangeListener {
        private ActionList list;
        private int start;
        private int lastSize;
        private boolean hasSeparator;

        public ListRangeTracker(int start, ActionList list) {
            this.setStartIndex(start);
            this.lastSize = list.size();
            list.addPropertyChangeListener(this);
            this.list = list;
        }

        public ActionList getList() {
            return this.list;
        }

        public int getInsertIndex() {
            return this.start + (this.hasSeparator ? 1 : 0);
        }

        public void setStartIndex(int start) {
            this.start = start;
        }

        public boolean needsSeparator() {
            return this.start > 0 && this.lastSize > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recalculateSeparator() {
            ActionListGroup.this.internalMod++;
            try {
                if (this.needsSeparator() && !this.hasSeparator) {
                    this.hasSeparator = true;
                    ActionListGroup.this.add(this.start, (Object)null);
                    ActionListGroup.this.adjustRanges(this.start, 1, ActionListGroup.this.ranges.indexOf(this));
                } else if (!this.needsSeparator() && this.hasSeparator) {
                    this.hasSeparator = false;
                    ActionListGroup.this.remove(this.start);
                    ActionListGroup.this.adjustRanges(this.start, -1, ActionListGroup.this.ranges.indexOf(this));
                }
            }
            finally {
                ActionListGroup.this.internalMod--;
            }
        }

        public void adjustStartIndex(int delta) {
            this.setStartIndex(this.start + delta);
        }

        public int getStartIndex() {
            return this.start;
        }

        public int getSize() {
            return this.lastSize + (this.hasSeparator ? 1 : 0);
        }

        public void clear() {
            this.list.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if (!(event instanceof ListPropertyChangeEvent)) {
                return;
            }
            ActionListGroup.this.internalMod++;
            try {
                int baseIndex = this.getInsertIndex();
                int rangeIndex = ActionListGroup.this.ranges.indexOf(this);
                int count = 0;
                ListPropertyChangeEvent lce = (ListPropertyChangeEvent)event;
                switch (lce.getType()) {
                    case 0: {
                        for (int i = lce.getFirstIndex(); i <= lce.getLastIndex(); ++i) {
                            ActionListGroup.this.add(baseIndex + i, this.list.get(i));
                            ++count;
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        for (int i = lce.getLastIndex(); i >= lce.getFirstIndex(); --i) {
                            ActionListGroup.this.remove(baseIndex + i);
                            --count;
                        }
                        break;
                    }
                }
                ActionListGroup.this.adjustRanges(baseIndex, count, rangeIndex);
                this.lastSize = this.list.size();
                this.recalculateSeparator();
            }
            finally {
                ActionListGroup.this.internalMod--;
            }
        }

        public String toString() {
            return "Range[" + this.start + ", " + (this.start + this.getSize()) + "]";
        }
    }
}

