/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.beans.BeanPropertyAdapter;
import org.progeeks.util.log.Log;
import org.progeeks.util.swing.ActionList;

public class ActionPropertyAdapter
extends BeanPropertyAdapter {
    static Log log = Log.getLog();
    private static PropertyAccess instance = new ActionPropertyAdapter();

    public static PropertyAccess getInstance() {
        return instance;
    }

    protected String normalizeProperty(String field) {
        if ("name".equals(field)) {
            field = "Name";
        } else if ("shortDescription".equals(field)) {
            field = "ShortDescription";
        } else if ("longDescription".equals(field)) {
            field = "LongDescription";
        } else if ("smallIcon".equals(field)) {
            field = "SmallIcon";
        } else if ("actionCommandKey".equals(field)) {
            field = "ActionCommandKey";
        } else if ("acceleratorKey".equals(field)) {
            field = "AcceleratorKey";
        } else if ("mnemonicKey".equals(field)) {
            field = "MnemonicKey";
        }
        return field;
    }

    public Object getProperty(Object object, String property) {
        if (super.hasProperty(object, property)) {
            return super.getProperty(object, property);
        }
        if (object instanceof ActionList && "actions".equals(property)) {
            return object;
        }
        return ((Action)object).getValue(this.normalizeProperty(property));
    }

    public boolean hasProperty(Object object, String property) {
        return true;
    }

    public boolean hasMutableProperty(Object object, String property) {
        return !super.hasProperty(object, property) || super.hasMutableProperty(object, property);
    }

    public void setProperty(Object object, String property, Object value) {
        if (super.hasMutableProperty(object, property)) {
            super.setProperty(object, property, value);
            return;
        }
        if (object instanceof ActionList && "actions".equals(property)) {
            ActionList al = (ActionList)object;
            al.clear();
            if (value instanceof ActionList) {
                al.add(value);
            } else {
                al.addAll((Collection)value);
            }
        }
        ((Action)object).putValue(this.normalizeProperty(property), value);
    }

    public Class getPropertyClass(Object object, String property) {
        Class c = super.getPropertyClass(object, property);
        if (c != null) {
            return c;
        }
        if (object instanceof ActionList && "actions".equals(property)) {
            return List.class;
        }
        return Object.class;
    }

    public boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        ((Action)object).addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return super.addPropertyChangeListener(object, property, listener);
    }

    public boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        ((Action)object).removePropertyChangeListener(listener);
        return true;
    }

    public boolean removePropertyChangeListener(Object object, String property, PropertyChangeListener listener) {
        return super.removePropertyChangeListener(object, property, listener);
    }
}

