/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.progeeks.util.ListPropertyChangeListener;
import org.progeeks.util.swing.ActionList;
import org.progeeks.util.swing.ActionUtils;

public class ActionToolPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private ActionList actions;
    private ListObserver listObserver = new ListObserver();
    private JPanel spacer = new JPanel();
    private Border border;

    public ActionToolPanel() {
        this.setLayout(new GridBagLayout());
        this.border = this.getBorder();
    }

    public ActionToolPanel(ActionList actions) {
        this();
        this.setActions(actions);
    }

    public void setActions(ActionList actions) {
        ActionList list;
        int index;
        if (this.actions != null) {
            this.actions.removePropertyChangeListener(this.listObserver);
            index = 0;
            for (Object o : this.actions) {
                if (o instanceof ActionList) {
                    list = (ActionList)o;
                    this.removeToolBar(index, list);
                } else {
                    this.removeTool(index, (Action)o);
                }
                ++index;
            }
        }
        this.actions = actions;
        if (this.actions != null) {
            this.actions.addPropertyChangeListener(this.listObserver);
            index = 0;
            for (Object o : this.actions) {
                if (o instanceof ActionList) {
                    list = (ActionList)o;
                    this.addToolBar(index, list);
                } else {
                    this.addTool(index, (Action)o);
                }
                ++index;
            }
        }
    }

    public ActionList getActions() {
        return this.actions;
    }

    public void setBorder(Border b) {
        this.border = b;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component o = this.getComponent(i);
            if (!(o instanceof JToolBar)) continue;
            ((JToolBar)o).setBorder(b);
        }
        if (this.spacer != null) {
            this.spacer.setBorder(b);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    protected GridBagConstraints getGbc() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        return gbc;
    }

    protected void addToolBar(int index, ActionList tools) {
        this.remove(this.spacer);
        JToolBar toolBar = ActionUtils.createToolBar(tools);
        if (this.border != null) {
            toolBar.setBorder(this.border);
        }
        toolBar.setFloatable(false);
        GridBagConstraints gbc = this.getGbc();
        gbc.gridx = index;
        this.add(toolBar, gbc, index);
        gbc.gridx = this.actions.size();
        gbc.weightx = 1.0;
        this.add((Component)this.spacer, gbc);
    }

    protected void removeToolBar(int index, ActionList tools) {
        this.remove(this.spacer);
        this.remove(index);
        GridBagConstraints gbc = this.getGbc();
        gbc.gridx = this.actions.size();
        gbc.weightx = 1.0;
        this.add((Component)this.spacer, gbc);
    }

    protected void addTool(int index, Action tool) {
        this.remove(this.spacer);
        JComponent c = ActionUtils.createToolBarButton(tool);
        GridBagConstraints gbc = this.getGbc();
        gbc.gridx = index;
        this.add(c, gbc, index);
        gbc.gridx = this.actions.size();
        gbc.weightx = 1.0;
        this.add((Component)this.spacer, gbc);
    }

    protected void removeTool(int index, Action tool) {
        this.remove(this.spacer);
        this.remove(index);
        GridBagConstraints gbc = this.getGbc();
        gbc.gridx = this.actions.size();
        gbc.weightx = 1.0;
        this.add((Component)this.spacer, gbc);
    }

    private class ListObserver
    extends ListPropertyChangeListener {
        private ListObserver() {
        }

        protected void itemInserted(Object source, int index, List oldList, List newList) {
            Object item = newList.get(index);
            if (item instanceof ActionList) {
                ActionList list = (ActionList)item;
                ActionToolPanel.this.addToolBar(index, list);
            } else if (item instanceof Action) {
                ActionToolPanel.this.addTool(index, (Action)item);
            } else if (item != null) {
                throw new RuntimeException("Type mismatch: not an ActionList type:" + item.getClass());
            }
        }

        protected void itemUpdated(Object source, int index, List oldList, List newList) {
            this.itemDeleted(source, index, oldList, newList);
            this.itemInserted(source, index, oldList, newList);
        }

        protected void itemDeleted(Object source, int index, List oldList, List newList) {
            Object item = oldList.get(index);
            if (item instanceof ActionList) {
                ActionToolPanel.this.removeToolBar(index, (ActionList)item);
            } else {
                ActionToolPanel.this.removeTool(index, (Action)item);
            }
        }
    }
}

