/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.progeeks.util.Inspector;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.ListPropertyChangeListener;
import org.progeeks.util.ViewContextAware;
import org.progeeks.util.log.Log;
import org.progeeks.util.swing.ActionList;
import org.progeeks.util.swing.ActionListButton;
import org.progeeks.util.swing.EnhancedButton;
import org.progeeks.util.swing.TogglableAction;

public class ActionUtils {
    static Log log = Log.getLog(ActionUtils.class);
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public static JMenu createActionMenu(ActionList actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Cannot create menu for null action list.");
        }
        JMenu main = new JMenu(actions);
        for (Action a : actions) {
            if (a == null) {
                main.addSeparator();
                continue;
            }
            main.add(ActionUtils.createActionMenuItem(a));
        }
        actions.addPropertyChangeListener(new ActionMenuCoordinator(main));
        return main;
    }

    public static JMenuBar createActionMenuBar(ActionList actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Cannot create menu for null action list.");
        }
        JMenuBar main = new JMenuBar();
        for (Action a : actions) {
            if (a instanceof ActionList) {
                main.add(ActionUtils.createActionMenu((ActionList)a));
                continue;
            }
            if (a == null) {
                main.add(new JSeparator(1));
                continue;
            }
            main.add(new JMenu(a));
        }
        actions.addPropertyChangeListener(new ActionMenuCoordinator(main));
        return main;
    }

    public static JPopupMenu createPopupMenu(ActionList actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Cannot create menu for null action list.");
        }
        JPopupMenu main = new JPopupMenu();
        for (Action a : actions) {
            if (a == null) {
                main.addSeparator();
                continue;
            }
            main.add(ActionUtils.createActionMenuItem(a));
        }
        actions.addPropertyChangeListener(new ActionMenuCoordinator(main));
        return main;
    }

    public static JToolBar createToolBar(ActionList actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Cannot create menu for null action list.");
        }
        String name = (String)actions.getValue("Name");
        if (name == null) {
            name = "Tools";
        }
        JToolBar tools = new JToolBar(name);
        tools.setRollover(true);
        ActionToolBarCoordinator coordinator = new ActionToolBarCoordinator(tools);
        actions.addPropertyChangeListener(coordinator);
        int index = 0;
        for (Action a : actions) {
            coordinator.addTool(index, a);
            ++index;
        }
        return tools;
    }

    public static JMenuItem createActionMenuItem(Action a) {
        if (a instanceof ActionList) {
            return ActionUtils.createActionMenu((ActionList)a);
        }
        if (a instanceof TogglableAction) {
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(a);
            ((TogglableAction)((Object)a)).addButtonModel(cb.getModel());
            cb.setState(((TogglableAction)((Object)a)).isChecked());
            return cb;
        }
        return new JMenuItem(a);
    }

    public static JComponent createToolBarButton(Action a) {
        EnhancedButton b;
        if (a == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        if (a instanceof TogglableAction) {
            b = new EnhancedButton(a);
            b.setModel(new JToggleButton.ToggleButtonModel());
            ((TogglableAction)((Object)a)).addButtonModel(b.getModel());
        } else {
            b = new EnhancedButton(a);
        }
        if (a instanceof ActionList) {
            b.setMargin(ZERO_INSETS);
            b.setRolloverEnabled(true);
            ActionListButton popupButton = new ActionListButton(b, (ActionList)a);
            popupButton.setMargin(ZERO_INSETS);
            popupButton.setRolloverEnabled(true);
            return ActionListButton.createCombinedComponent(popupButton);
        }
        b.setMargin(ZERO_INSETS);
        b.setRolloverEnabled(true);
        return b;
    }

    public static Action cloneAction(Action o) {
        try {
            if (o instanceof ActionList) {
                return (ActionList)((ActionList)o).clone();
            }
            if (o instanceof Cloneable) {
                Inspector ins = new Inspector(o);
                if (ins.hasMethod("clone")) {
                    return (Action)ins.callMethod("clone");
                }
            } else if (o instanceof ViewContextAware) {
                log.warn("Object is not cloneable but is context aware:" + o + " This is usually a mistake.");
            }
        }
        catch (CloneNotSupportedException e) {
            log.warn("Cloning object:" + o + " failed", e);
        }
        return o;
    }

    private static class ActionToolBarCoordinator
    extends ListPropertyChangeListener {
        private JToolBar tools;

        public ActionToolBarCoordinator(JToolBar tools) {
            this.tools = tools;
        }

        public void addTool(int index, Action a) {
            if (a == null) {
                JToolBar.Separator s = new JToolBar.Separator(null);
                if (this.tools.getOrientation() == 1) {
                    s.setOrientation(0);
                } else {
                    s.setOrientation(1);
                }
                this.tools.add((Component)s, index);
                return;
            }
            this.tools.add((Component)ActionUtils.createToolBarButton(a), index);
        }

        public void removeTool(int index) {
            this.tools.remove(index);
        }

        protected void itemInserted(Object source, int index, List oldList, List newList) {
            Action a = (Action)newList.get(index);
            this.addTool(index, a);
        }

        protected void itemUpdated(Object source, int index, List oldList, List newList) {
            this.itemDeleted(source, index, oldList, newList);
            this.itemInserted(source, index, oldList, newList);
        }

        protected void itemDeleted(Object source, int index, List oldList, List newList) {
            this.removeTool(index);
        }
    }

    private static class ActionMenuCoordinator
    implements PropertyChangeListener {
        private JComponent menu;

        public ActionMenuCoordinator(JComponent menu) {
            this.menu = menu;
        }

        protected void addMenu(int index, Action a) {
            if (this.menu instanceof JMenu) {
                if (a == null) {
                    ((JMenu)this.menu).add((Component)new JSeparator(), index);
                } else {
                    ((JMenu)this.menu).add((Component)ActionUtils.createActionMenuItem(a), index);
                }
            } else if (this.menu instanceof JPopupMenu) {
                if (a == null) {
                    ((JPopupMenu)this.menu).add((Component)new JSeparator(), index);
                } else {
                    ((JPopupMenu)this.menu).add((Component)ActionUtils.createActionMenuItem(a), index);
                }
            } else if (this.menu instanceof JMenuBar) {
                if (a == null) {
                    ((JMenuBar)this.menu).add((Component)new JSeparator(1), index);
                } else {
                    ((JMenuBar)this.menu).add((Component)ActionUtils.createActionMenuItem(a), index);
                }
            }
        }

        protected void replaceMenu(int index, Action a) {
            this.removeMenu(index);
            this.addMenu(index, a);
        }

        protected void removeMenu(int index) {
            this.menu.remove(index);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!(event instanceof ListPropertyChangeEvent)) {
                return;
            }
            ActionList actions = (ActionList)event.getSource();
            ListPropertyChangeEvent lce = (ListPropertyChangeEvent)event;
            switch (lce.getType()) {
                case 0: {
                    for (int i = lce.getFirstIndex(); i <= lce.getLastIndex(); ++i) {
                        this.addMenu(i, (Action)actions.get(i));
                    }
                    break;
                }
                case 1: {
                    for (int i = lce.getFirstIndex(); i <= lce.getLastIndex(); ++i) {
                        this.replaceMenu(i, (Action)actions.get(i));
                    }
                    break;
                }
                case 2: {
                    for (int i = lce.getLastIndex(); i >= lce.getFirstIndex(); --i) {
                        this.removeMenu(i);
                    }
                    break;
                }
            }
        }
    }
}

