/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class BeveledBoxIcon
implements Icon {
    private Color highlight = Color.white;
    private Color shadow = Color.darkGray;
    private Color background = Color.lightGray;
    private int width;
    private int height;
    private boolean doubleBorder;

    public BeveledBoxIcon(int width, int height) {
        this(width, height, true);
    }

    public BeveledBoxIcon(int width, int height, boolean doubleBorder) {
        this.width = width;
        this.height = height;
        this.doubleBorder = doubleBorder;
    }

    public void setHighlightColor(Color highlight) {
        this.highlight = highlight;
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public void setShadowColor(Color shadow) {
        this.shadow = shadow;
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    public void setBackgroundColor(Color background) {
        this.background = background;
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public void setIconWidth(int width) {
        this.width = width;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void setIconHeight(int height) {
        this.height = height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.background);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(this.highlight);
        g.drawLine(x, y, x + this.width, y);
        g.drawLine(x, y, x, y + this.height);
        if (this.doubleBorder) {
            g.drawLine(x + 1, y + 1, x + this.width - 1, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + this.height - 1);
        }
        g.setColor(this.shadow);
        g.drawLine(x, y + this.height, x + this.width, y + this.height);
        g.drawLine(x + this.width, y, x + this.width, y + this.height);
        if (this.doubleBorder) {
            g.drawLine(x + 1, y + this.height - 1, x + this.width - 1, y + this.height - 1);
            g.drawLine(x + this.width - 1, y + 1, x + this.width - 1, y + this.height - 1);
        }
    }
}

