/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.Action;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.ListPropertyChangeListener;
import org.progeeks.util.swing.ActionList;
import org.progeeks.util.swing.CheckBoxAction;

public class CheckBoxActionGroup
extends ActionList {
    static final long serialVersionUID = 1L;
    private ListObserver listObserver = new ListObserver();
    private boolean inheritSelectedProperties;

    public CheckBoxActionGroup() {
        this.addPropertyChangeListener(this.listObserver);
    }

    public CheckBoxActionGroup(String name) {
        this(name, false);
    }

    public CheckBoxActionGroup(String name, boolean inheritSelectedProperties) {
        super(name);
        this.addPropertyChangeListener(this.listObserver);
        this.setInheritSelectedProperties(inheritSelectedProperties);
    }

    public void setInheritSelectedProperties(boolean flag) {
        this.inheritSelectedProperties = flag;
    }

    public boolean getInheritSelectedProperties() {
        return this.inheritSelectedProperties;
    }

    protected void preinitializeClone(ActionList clone) {
        CheckBoxActionGroup g = (CheckBoxActionGroup)clone;
        g.createListener();
    }

    protected void createListener() {
        this.listObserver = new ListObserver();
        this.addPropertyChangeListener(this.listObserver);
    }

    protected void setupChildListeners() {
    }

    protected void initializeClone(ActionList clone) {
        ((CheckBoxActionGroup)clone).setupChildListeners();
    }

    protected void updateState(CheckBoxAction action) {
        if (!action.isChecked()) {
            return;
        }
        for (CheckBoxAction a : this) {
            if (a == action) {
                if (!this.inheritSelectedProperties) continue;
                this.inheritProperties(a);
                continue;
            }
            a.setChecked(false);
        }
    }

    protected void inheritProperties(Action a) {
        this.putValue("Name", a.getValue("Name"));
        this.putValue("SmallIcon", a.getValue("SmallIcon"));
    }

    private class ListObserver
    extends ListPropertyChangeListener {
        private ListObserver() {
        }

        protected void itemInserted(Object source, int index, List oldList, List newList) {
            Object o = newList.get(index);
            if (!(o instanceof CheckBoxAction)) {
                throw new RuntimeException("Object is not a check box action:" + o);
            }
            ((CheckBoxAction)o).addPropertyChangeListener(CheckBoxActionGroup.this.listObserver);
        }

        protected void itemUpdated(Object source, int index, List oldList, List newList) {
            this.itemDeleted(source, index, oldList, newList);
            this.itemInserted(source, index, oldList, newList);
        }

        protected void itemDeleted(Object source, int index, List oldList, List newList) {
            Object o = oldList.get(index);
            if (!(o instanceof CheckBoxAction)) {
                throw new RuntimeException("Object is not a check box action:" + o);
            }
            ((CheckBoxAction)o).removePropertyChangeListener(CheckBoxActionGroup.this.listObserver);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof ListPropertyChangeEvent) {
                super.propertyChange(event);
                return;
            }
            String name = event.getPropertyName();
            if ("checked".equals(name)) {
                CheckBoxActionGroup.this.updateState((CheckBoxAction)event.getSource());
            }
        }
    }
}

