/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.progeeks.util.swing.ActionDelegateAdapter;

public class FontChooser
extends JPanel {
    static final long serialVersionUID = 1L;
    private static String[] familyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static String[] styleNames = new String[]{"Regular", "Italic", "Bold", "Bold Italic"};
    private Font selectedFont;
    private JComboBox family;
    private JComboBox style;
    private JSpinner size;
    private JLabel preview;

    public FontChooser() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Font:"), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        this.family = new JComboBox<String>(familyNames);
        this.family.addItemListener(new FamilyListener());
        this.add((Component)this.family, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Style:"), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        this.style = new JComboBox<String>(styleNames);
        this.style.addItemListener(new StyleListener());
        this.add((Component)this.style, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Size:"), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        SpinnerNumberModel spinModel = new SpinnerNumberModel(12, 1, 72, 1);
        this.size = new JSpinner(spinModel);
        this.size.addChangeListener(new SizeListener());
        this.add((Component)this.size, gbc);
        this.preview = new JLabel("AaBbYyZz");
        EmptyBorder inner = new EmptyBorder(5, 10, 5, 10);
        BevelBorder outer = new BevelBorder(1);
        this.preview.setBorder(new CompoundBorder(new TitledBorder("Preview"), new CompoundBorder(outer, inner)));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        this.add((Component)this.preview, gbc);
    }

    private String styleToString(int style) {
        if (style == 0) {
            return "Regular";
        }
        if (style == 1) {
            return "Bold";
        }
        if (style == 2) {
            return "Italic";
        }
        if (style == 3) {
            return "Bold Italic";
        }
        return "Uknown";
    }

    private int stringToStyle(String style) {
        if ("Regular".equals(style)) {
            return 0;
        }
        if ("Bold".equals(style)) {
            return 1;
        }
        if ("Italic".equals(style)) {
            return 2;
        }
        if ("Bold Italic".equals(style)) {
            return 3;
        }
        return 0;
    }

    public void setSelectedFont(Font f) {
        if (this.selectedFont == f || f != null && f.equals(this.selectedFont)) {
            return;
        }
        this.selectedFont = f;
        this.resetPreview();
        if (f != null) {
            String name = f.getFamily();
            this.family.setSelectedItem(name);
            this.style.setSelectedItem(this.styleToString(f.getStyle()));
            this.size.setValue(new Integer(f.getSize()));
        } else {
            this.family.setSelectedIndex(-1);
            this.style.setSelectedIndex(-1);
            this.size.setValue(new Integer(1));
        }
    }

    protected void resetPreview() {
        this.preview.setFont(this.selectedFont);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public static Font showDialog(Component component, String title, Font initialFont) {
        FontChooserDialog dlg = new FontChooserDialog(component, title, initialFont, true);
        dlg.setVisible(true);
        dlg.dispose();
        return dlg.getSelectedFont();
    }

    public static void main(String[] args) {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            System.out.println("font[" + i + "] = " + fonts[i]);
        }
        Font f = FontChooser.showDialog(null, "Font Test", Font.decode("arial-18"));
        System.out.println("Font selected:" + f);
    }

    private static class FontChooserDialog
    extends JDialog {
        static final long serialVersionUID = 1L;
        private FontChooser chooser;
        private Font initialFont;

        public FontChooserDialog(Component component, String title, Font initialFont, boolean modal) {
            this.setTitle(title);
            this.setModal(modal);
            this.chooser = new FontChooser();
            this.chooser.setSelectedFont(initialFont);
            this.initialFont = initialFont;
            this.getContentPane().add((Component)this.chooser, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(new JButton(new ActionDelegateAdapter("Ok", this, "ok")));
            buttonPanel.add(new JButton(new ActionDelegateAdapter("Cancel", this, "cancel")));
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setLocationRelativeTo(component);
        }

        public Font getSelectedFont() {
            return this.chooser.getSelectedFont();
        }

        public void ok() {
            this.setVisible(false);
        }

        public void cancel() {
            this.chooser.setSelectedFont(this.initialFont);
            this.setVisible(false);
        }
    }

    private class SizeListener
    implements ChangeListener {
        private SizeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int i = (Integer)FontChooser.this.size.getValue();
            if (FontChooser.this.selectedFont != null && i != FontChooser.this.selectedFont.getSize()) {
                FontChooser.this.setSelectedFont(FontChooser.this.selectedFont.deriveFont((float)i));
            } else if (FontChooser.this.selectedFont == null) {
                Font f = Font.decode(familyNames[0] + "-" + i);
                FontChooser.this.setSelectedFont(f);
            }
        }
    }

    private class StyleListener
    implements ItemListener {
        private StyleListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            String s = (String)FontChooser.this.style.getSelectedItem();
            if (s == null) {
                return;
            }
            if (FontChooser.this.selectedFont != null) {
                FontChooser.this.setSelectedFont(FontChooser.this.selectedFont.deriveFont(FontChooser.this.stringToStyle(s)));
            } else {
                Font f = Font.decode(familyNames[0] + "-" + FontChooser.this.stringToStyle(s));
                FontChooser.this.setSelectedFont(f);
            }
        }
    }

    private class FamilyListener
    implements ItemListener {
        private FamilyListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            String name = (String)FontChooser.this.family.getSelectedItem();
            if (name == null) {
                return;
            }
            if (FontChooser.this.selectedFont != null) {
                if (name.equals(FontChooser.this.selectedFont.getFamily())) {
                    return;
                }
                int style = FontChooser.this.selectedFont.getStyle();
                int size = FontChooser.this.selectedFont.getSize();
                Font f = new Font(name, style, size);
                FontChooser.this.setSelectedFont(f);
            } else {
                Font f = Font.decode(name);
                FontChooser.this.setSelectedFont(f);
            }
        }
    }
}

