/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.ObservableList;

public class ObservableListModel
extends AbstractListModel {
    static final long serialVersionUID = 1L;
    private ObservableList list;
    private ListListener listListener = new ListListener();

    public ObservableListModel() {
        this(null);
    }

    public ObservableListModel(ObservableList list) {
        this.setObservableList(list);
    }

    public void setObservableList(ObservableList list) {
        if (this.list != null) {
            this.list.removePropertyChangeListener(this.listListener);
        }
        this.list = list;
        if (this.list != null) {
            this.list.addPropertyChangeListener(this.listListener);
            this.fireContentsChanged(this, 0, this.list.size());
        }
    }

    public ObservableList getObservableList() {
        return this.list;
    }

    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    public int getSize() {
        return this.list != null ? this.list.size() : 0;
    }

    private class ListListener
    implements PropertyChangeListener {
        private ListListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!(event instanceof ListPropertyChangeEvent)) {
                ObservableListModel.this.fireContentsChanged(ObservableListModel.this, 0, ObservableListModel.this.getSize());
                return;
            }
            ListPropertyChangeEvent listEvent = (ListPropertyChangeEvent)event;
            int first = listEvent.getFirstIndex();
            int last = listEvent.getLastIndex();
            switch (listEvent.getType()) {
                case 2: {
                    ObservableListModel.this.fireIntervalRemoved(ObservableListModel.this, first, last);
                    break;
                }
                case 0: {
                    ObservableListModel.this.fireIntervalAdded(ObservableListModel.this, first, last);
                    break;
                }
                case 1: {
                    ObservableListModel.this.fireContentsChanged(ObservableListModel.this, first, last);
                    break;
                }
            }
        }
    }
}

