/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class RenderedIcon
implements Icon {
    private Icon icon;
    private BufferedImage image;
    private int width;
    private int height;

    public RenderedIcon() {
    }

    public RenderedIcon(Icon icon) {
        this.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.image = null;
        this.width = icon.getIconWidth();
        this.height = icon.getIconHeight();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null) {
            return;
        }
        if (this.image == null) {
            this.image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
            Graphics gImg = this.image.getGraphics();
            this.icon.paintIcon(c, gImg, 0, 0);
            gImg.dispose();
        }
        g.drawImage(this.image, x, y, null);
    }
}

