/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class ScaledIcon
implements Icon,
SwingConstants {
    private Icon icon;
    private double xScale;
    private double yScale;
    private double xUnscale;
    private double yUnscale;
    private boolean antialias = false;

    public ScaledIcon() {
        this(null, 1.0, 1.0);
    }

    public ScaledIcon(Icon icon) {
        this(icon, 1.0, 1.0);
    }

    public ScaledIcon(Icon icon, double xScale, double yScale) {
        this.icon = icon;
        this.xScale = xScale;
        this.yScale = yScale;
        this.xUnscale = 1.0 / xScale;
        this.yUnscale = 1.0 / yScale;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setXScale(double xScale) {
        this.xScale = xScale;
        this.xUnscale = 1.0 / xScale;
    }

    public double getXScale() {
        return this.xScale;
    }

    public void setYScale(double yScale) {
        this.yScale = yScale;
        this.yUnscale = 1.0 / yScale;
    }

    public double getYScale() {
        return this.yScale;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.xScale, this.yScale);
        Object oldVal = null;
        if (this.antialias) {
            oldVal = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        this.icon.paintIcon(c, g, (int)((double)x * this.xUnscale), (int)((double)y * this.yUnscale));
        if (this.antialias) {
            if (oldVal == null) {
                g2.getRenderingHints().remove(RenderingHints.KEY_INTERPOLATION);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldVal);
            }
        }
        g2.scale(this.xUnscale, this.yUnscale);
    }

    public int getIconWidth() {
        return (int)Math.round((double)this.icon.getIconWidth() * this.xScale);
    }

    public int getIconHeight() {
        return (int)Math.round((double)this.icon.getIconHeight() * this.yScale);
    }
}

