/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SortedTableModel
extends AbstractTableModel {
    static final long serialVersionUID = 1L;
    public static final Comparator DEFAULT_COLUMN_COMPARATOR = new StandardColumnComparator();
    protected int[] indexMap;
    protected int[] reverseMap;
    protected TableModel model;
    protected int primarySort = 0;
    protected int secondarySort = 1;
    protected boolean reversed = false;

    public SortedTableModel(TableModel model) {
        this(model, 0, 1);
    }

    public SortedTableModel(TableModel model, int primarySort, int secondarySort) {
        this.model = model;
        this.primarySort = primarySort;
        this.secondarySort = secondarySort;
        model.addTableModelListener(new ModelChangeListener());
        this.resortTable();
    }

    public void clearSort() {
        this.reversed = false;
        this.setSortColumns(-1, -1);
    }

    public boolean isSortable(int column) {
        return true;
    }

    public void setSortColumns(int primary, int secondary) {
        this.primarySort = primary;
        this.secondarySort = secondary;
        this.resortTable();
    }

    public void pushSortColumn(int column) {
        this.secondarySort = this.primarySort;
        this.primarySort = column;
        this.resortTable();
    }

    public void setPrimarySortColumn(int column) {
        this.primarySort = column;
        this.resortTable();
    }

    public int getPrimarySortColumn() {
        return this.primarySort;
    }

    public void setSecondarySortColumn(int column) {
        this.secondarySort = column;
        this.resortTable();
    }

    public int getSecondarySortColumn() {
        return this.secondarySort;
    }

    public void setReversed(boolean flag) {
        this.reversed = flag;
        this.resortTable();
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Comparator getColumnComparator(int index) {
        return DEFAULT_COLUMN_COMPARATOR;
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getColumnCount();
    }

    public String getColumnName(int column) {
        if (this.model == null) {
            return null;
        }
        return this.model.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        if (this.model == null) {
            return null;
        }
        return this.model.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        if (this.model == null) {
            return false;
        }
        return this.model.isCellEditable(this.toRealIndex(row), column);
    }

    public Object getValueAt(int row, int column) {
        if (this.model == null) {
            return null;
        }
        return this.model.getValueAt(this.toRealIndex(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.model.setValueAt(aValue, this.toRealIndex(row), column);
    }

    public int toRealIndex(int sorted) {
        if (sorted < 0) {
            return sorted;
        }
        return this.indexMap[sorted];
    }

    public int toSortedIndex(int real) {
        if (real < 0) {
            return real;
        }
        return this.reverseMap[real];
    }

    protected void resetIndexMap() {
        this.indexMap = new int[this.model.getRowCount()];
        this.reverseMap = new int[this.model.getRowCount()];
        for (int i = 0; i < this.indexMap.length; ++i) {
            this.indexMap[i] = i;
            this.reverseMap[i] = i;
        }
    }

    protected boolean resortTable() {
        if (this.primarySort < 0) {
            this.resetIndexMap();
            this.fireTableDataChanged();
            return true;
        }
        if (this.indexMap == null || this.indexMap.length != this.model.getRowCount()) {
            this.resetIndexMap();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.indexMap.length);
        for (int i = 0; i < this.indexMap.length; ++i) {
            list.add(new Integer(this.indexMap[i]));
        }
        TableComparator comp = new TableComparator(this.primarySort, this.secondarySort);
        Collections.sort(list, comp);
        int i = 0;
        while (i < this.indexMap.length) {
            int index;
            this.indexMap[i] = index = ((Integer)list.get(i)).intValue();
            this.reverseMap[index] = i++;
        }
        this.fireTableDataChanged();
        return true;
    }

    private class ModelChangeListener
    implements TableModelListener {
        private ModelChangeListener() {
        }

        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case -1: 
                case 1: {
                    SortedTableModel.this.resortTable();
                    SortedTableModel.this.fireTableDataChanged();
                    return;
                }
            }
            int row1 = e.getFirstRow();
            int row2 = e.getLastRow();
            if (row1 == -1 && e.getColumn() == -1) {
                SortedTableModel.this.primarySort = 0;
                SortedTableModel.this.secondarySort = 1;
                SortedTableModel.this.resortTable();
                SortedTableModel.this.fireTableStructureChanged();
                return;
            }
            if (row1 == 0 && row2 == Integer.MAX_VALUE && e.getColumn() == -1) {
                SortedTableModel.this.resortTable();
                SortedTableModel.this.fireTableDataChanged();
                return;
            }
            if (row1 != row2) {
                return;
            }
            row1 = SortedTableModel.this.toSortedIndex(row1);
            TableModelEvent newEvent = new TableModelEvent(SortedTableModel.this, row1, row1, e.getColumn(), e.getType());
            SortedTableModel.this.fireTableChanged(newEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardColumnComparator
    implements Comparator<Object> {
        protected int compareValues(Comparable c1, Comparable c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            return c1.compareTo(c2);
        }

        @Override
        public int compare(Object o1, Object o2) {
            if ((o1 == null || o1 instanceof Comparable) && (o2 == null || o2 instanceof Comparable)) {
                return this.compareValues((Comparable)o1, (Comparable)o2);
            }
            String s1 = String.valueOf(o1);
            String s2 = String.valueOf(o2);
            return s1.compareTo(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TableComparator
    implements Comparator<Integer> {
        private int primary;
        private int secondary;
        private Comparator primarySorter;
        private Comparator secondarySorter;

        public TableComparator(int primary, int secondary) {
            this.primary = primary;
            this.secondary = secondary;
            this.primarySorter = SortedTableModel.this.getColumnComparator(primary);
            this.secondarySorter = SortedTableModel.this.getColumnComparator(secondary);
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            Object val2;
            int row1 = o1;
            int row2 = o2;
            Object val1 = SortedTableModel.this.model.getValueAt(row1, this.primary);
            int result = this.primarySorter.compare(val1, val2 = SortedTableModel.this.model.getValueAt(row2, this.primary));
            if (result == 0 && this.secondary >= 0) {
                val1 = SortedTableModel.this.model.getValueAt(row1, this.secondary);
                val2 = SortedTableModel.this.model.getValueAt(row2, this.secondary);
                result = this.secondarySorter.compare(val1, val2);
            }
            if (SortedTableModel.this.reversed) {
                result *= -1;
            }
            return result;
        }
    }
}

