/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;
import org.progeeks.util.log.Log;

public class SwingThreadInvoker
implements InvocationHandler {
    static Log log = Log.getLog(SwingThreadInvoker.class);
    private Object delegate;

    public SwingThreadInvoker(Object delegate) {
        this.delegate = delegate;
    }

    public static Object synchronizeObject(Object delegate, Class proxyInterface) {
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new SwingThreadInvoker(delegate));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("invoke(" + method + ")");
        }
        if (EventQueue.isDispatchThread()) {
            return method.invoke(this.delegate, args);
        }
        MethodRunner r = new MethodRunner(this.delegate, method, args);
        SwingUtilities.invokeLater(r);
        return r.waitForResult();
    }

    private static class MethodRunner
    implements Runnable {
        private Object delegate;
        private Method method;
        private Object[] args;
        private Throwable throwable;
        private Object result;
        private boolean done = false;

        public MethodRunner(Object delegate, Method method, Object[] args) {
            this.delegate = delegate;
            this.method = method;
            this.args = args;
        }

        public boolean returnsResult() {
            Class<?> c = this.method.getReturnType();
            return !c.equals(Void.TYPE);
        }

        public synchronized Object waitForResult() throws Throwable {
            if (!this.returnsResult()) {
                return null;
            }
            while (!this.done) {
                this.wait();
            }
            if (this.throwable != null) {
                throw this.throwable;
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                this.result = this.method.invoke(this.delegate, this.args);
            }
            catch (InvocationTargetException e) {
                this.throwable = e.getCause();
            }
            catch (Exception e) {
                log.error("Error delegating method[" + this.method + "]", e);
            }
            finally {
                this.done = true;
                this.notifyAll();
            }
        }
    }
}

