/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.thread;

public class ConditionalLock {
    private boolean state;

    public ConditionalLock() {
    }

    public ConditionalLock(boolean state) {
        this.state = state;
    }

    public synchronized boolean isTrue() {
        return this.state;
    }

    public synchronized void setFalse() {
        this.state = false;
        this.notifyAll();
    }

    public synchronized void setTrue() {
        this.state = true;
        this.notifyAll();
    }

    public synchronized void setState(boolean state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.notifyAll();
    }

    public synchronized void waitForTrue(long timeout) throws InterruptedException {
        if (!this.state && timeout > 0L) {
            this.wait(timeout);
        }
    }

    public synchronized void waitForTrue() throws InterruptedException {
        while (!this.state) {
            this.wait();
        }
    }

    public synchronized void waitForFalse(long timeout) throws InterruptedException {
        if (this.state && timeout > 0L) {
            this.wait(timeout);
        }
    }

    public synchronized void waitForFalse() throws InterruptedException {
        while (this.state) {
            this.wait();
        }
    }
}

