/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.progeeks.util.Inspector;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class ActionObjectHandler
extends BeanObjectHandler {
    static Log log = Log.getLog(ActionObjectHandler.class);

    public boolean canHandle(String tag) {
        if (log.isDebugEnabled()) {
            log.debug("canHandle(" + tag + ")");
        }
        if ("null".equals(tag)) {
            return true;
        }
        Class c = this.getTagClass(tag);
        if (c == null) {
            return false;
        }
        return Action.class.isAssignableFrom(c);
    }

    protected void setActionProperty(Action a, String field, Object value) {
        if ("name".equals(field)) {
            field = "Name";
        } else if ("shortDescription".equals(field)) {
            field = "ShortDescription";
        } else if ("longDescription".equals(field)) {
            field = "LongDescription";
        } else if ("smallIcon".equals(field)) {
            field = "SmallIcon";
        } else if ("actionCommandKey".equals(field)) {
            field = "ActionCommandKey";
        } else if ("acceleratorKey".equals(field)) {
            field = "AcceleratorKey";
        } else if ("mnemonicKey".equals(field)) {
            field = "MnemonicKey";
        }
        a.putValue(field, value);
    }

    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        if (ins.hasMutator(field)) {
            super.setProperty(obj, field, value, reader);
        } else {
            this.setActionProperty((Action)obj, field, value);
        }
    }

    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        if (ins.hasMutator(field)) {
            super.setTextProperty(obj, field, value, reader);
            return;
        }
        Object v = this.getConstant(value, obj.getClass());
        if (v == null) {
            v = value;
        }
        this.setActionProperty((Action)obj, field, v);
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        Class type = ins.getType(field);
        if (type != null) {
            return super.getPropertyClass(obj, field, reader);
        }
        return Object.class;
    }

    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        if (ins.getType(field) != null) {
            return super.getPropertyCollection(obj, field, reader);
        }
        Action a = (Action)obj;
        ArrayList c = (ArrayList)a.getValue(field);
        if (c == null) {
            c = new ArrayList();
            this.setActionProperty((Action)obj, field, c);
        }
        return c;
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        if ("null".equals(tag)) {
            return null;
        }
        Class type = this.getTagClass(tag);
        log.debug("createObject() type:" + type);
        String ctorVal = atts.getValue("_ctor");
        if (ctorVal != null || Inspector.hasConstructor(type, new Class[0])) {
            return super.createObject(tag, atts, reader);
        }
        if (!Inspector.hasConstructor(type, String.class)) {
            throw new RuntimeException("Cannot instantiate object of type:" + tag + "  No valid constructor.");
        }
        String name = atts.getValue("name");
        if (name == null) {
            throw new RuntimeException("Cannot instantiate object of type:" + tag + "  No valid constructor and no name attribute specified.");
        }
        Object bean = Inspector.newInstance(type, name);
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }
}

