/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.lang.reflect.Method;
import java.util.Collection;
import org.progeeks.util.beans.BeanConfigurator;
import org.progeeks.util.beans.SingletonConfigurator;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class BeanConfiguratorHandler
extends BeanObjectHandler {
    static Log log = Log.getLog(BeanConfiguratorHandler.class);
    public static final String CONFIGURATOR_PREFIX = "factory-";
    public static final String SINGLETON_PREFIX = "singletonFactory-";

    protected String getUnprefixedName(String tag) {
        if (tag.startsWith(CONFIGURATOR_PREFIX)) {
            return tag.substring(CONFIGURATOR_PREFIX.length());
        }
        if (tag.startsWith(SINGLETON_PREFIX)) {
            return tag.substring(SINGLETON_PREFIX.length());
        }
        return null;
    }

    public boolean canHandle(String tag) {
        String cName;
        if (log.isDebugEnabled()) {
            log.debug("canHandle(" + tag + ")");
        }
        if ((cName = this.getUnprefixedName(tag)) == null) {
            return false;
        }
        return super.canHandle(cName);
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        if (!(obj instanceof BeanConfigurator)) {
            return super.getPropertyClass(obj, field, reader);
        }
        BeanConfigurator factory = (BeanConfigurator)obj;
        Class beanType = factory.getBeanClass();
        if (beanType == null) {
            return super.getPropertyClass(obj, field, reader);
        }
        String stub = field.substring(0, 1).toUpperCase() + field.substring(1);
        String methodName = "set" + stub;
        Method[] list = beanType.getMethods();
        for (int i = 0; i < list.length; ++i) {
            Class<?>[] parmTypes;
            if (!methodName.equals(list[i].getName()) || (parmTypes = list[i].getParameterTypes()).length != 1) continue;
            return parmTypes[0];
        }
        methodName = "get" + stub;
        try {
            Method m = beanType.getMethod(methodName, null);
            Class<?> type = m.getReturnType();
            if (factory.getAppendCollections() && Collection.class.isAssignableFrom(type)) {
                return Collection.class;
            }
            return m.getReturnType();
        }
        catch (NoSuchMethodException e) {
            return super.getPropertyClass(obj, field, reader);
        }
    }

    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        if (!(obj instanceof BeanConfigurator)) {
            return super.getPropertyCollection(obj, field, reader);
        }
        throw new UnsupportedOperationException("BeanConfigurator cannot provide pre-initialized collections. Object:" + obj + "  Field:" + field);
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        String cName = this.getUnprefixedName(tag);
        Class type = this.getTagClass(cName);
        if (type == null) {
            throw new RuntimeException("Class not found:" + cName);
        }
        if (log.isDebugEnabled()) {
            log.debug("createObject() type: BeanConfigurator(" + type + ")");
        }
        BeanConfigurator bean = null;
        if (tag.startsWith(CONFIGURATOR_PREFIX)) {
            bean = new BeanConfigurator(type);
        } else if (tag.startsWith(SINGLETON_PREFIX)) {
            bean = new SingletonConfigurator(type);
        }
        if (bean == null) {
            throw new RuntimeException("Unknown prefix in tag:" + tag);
        }
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }
}

