/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.progeeks.util.Fixable;
import org.progeeks.util.Inspector;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.AbstractObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.progeeks.util.xml.XmlException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanObjectHandler
extends AbstractObjectHandler {
    static Log log = Log.getLog(BeanObjectHandler.class);
    public static final String CONFIG_IMPORT_PACKAGE = "importPackage";
    private static final Pattern CONSTANT = Pattern.compile("(?i)[a-z_$][a-z_0-9.$]*");
    private List<String> packages = new ArrayList<String>();
    private Map<String, Class> classCache = new HashMap<String, Class>();
    private Set<String> classMiss = new HashSet<String>();

    public void importPackage(String packageName) {
        this.packages.add(packageName);
    }

    public void setPackages(List<String> packages) {
        if (this.packages == packages) {
            return;
        }
        this.packages.clear();
        this.packages.addAll(packages);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    protected Class getClass(String fullName) throws XmlException {
        if (log.isDebugEnabled()) {
            log.debug("getClass(" + fullName + ")");
        }
        try {
            Thread t = Thread.currentThread();
            return t.getContextClassLoader().loadClass(fullName);
        }
        catch (NoClassDefFoundError e) {
            log.debug("Class not found:" + fullName);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.debug("Class not found:" + fullName);
            return null;
        }
    }

    protected Class getInnerClass(String fullName) {
        int split = fullName.lastIndexOf(46);
        if (split < 0) {
            return null;
        }
        String p = fullName.substring(0, split);
        String n = fullName.substring(split + 1);
        return this.getClass(p + "$" + n);
    }

    protected Class getClass(String pkg, String name) throws XmlException {
        String className;
        Class type;
        if (log.isDebugEnabled()) {
            log.debug("getClass( " + pkg + ", " + name + " )");
        }
        if ((type = this.getClass(className = pkg + "." + name)) != null) {
            return type;
        }
        type = this.getInnerClass(className);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getTagClass(String tag) throws XmlException {
        if (tag == null || tag.length() == 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTagClass(" + tag + ")");
        }
        if (this.classMiss.contains(tag)) {
            return null;
        }
        Class type = this.classCache.get(tag);
        if (type != null) {
            return type;
        }
        try {
            type = this.getClass(tag);
            if (type != null) {
                Class clazz = type;
                return clazz;
            }
            type = this.getInnerClass(tag);
            if (type != null) {
                Class clazz = type;
                return clazz;
            }
            String name = tag.length() > 1 ? tag.substring(0, 1).toUpperCase() + tag.substring(1) : tag.toUpperCase();
            String className = name;
            type = this.getClass(className);
            if (type != null) {
                Class clazz = type;
                return clazz;
            }
            Iterator<String> i = this.packages.iterator();
            while (i.hasNext()) {
                type = this.getClass(i.next(), name);
                if (type == null) continue;
                Class clazz = type;
                return clazz;
            }
            Class clazz = null;
            return clazz;
        }
        finally {
            if (type != null) {
                this.classCache.put(tag, type);
            } else {
                this.classMiss.add(tag);
            }
        }
    }

    protected Object getConstant(String name, Class type) {
        if (log.isDebugEnabled()) {
            log.debug("Attempting to lookup[" + name + "] as a constant.");
        }
        if (!CONSTANT.matcher(name).matches()) {
            return null;
        }
        int split = name.lastIndexOf(46);
        if (split > 0) {
            String className = name.substring(0, split);
            name = name.substring(split + 1);
            try {
                Class c = this.getTagClass(className);
                if (c != null) {
                    type = c;
                }
            }
            catch (XmlException e) {
                log.info("Class not found for:" + className, e);
            }
        }
        if (type == null) {
            return null;
        }
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName()) || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                return fields[i].get(null);
            }
            catch (IllegalAccessException e) {
                log.warn("Error getting constant value:" + name, e);
            }
        }
        return null;
    }

    protected String resolveField(Object obj, String field) {
        return field;
    }

    @Override
    public boolean canHandle(String tag) {
        if (log.isDebugEnabled()) {
            log.debug("canHandle(" + tag + ")");
        }
        if ("null".equals(tag)) {
            return true;
        }
        if (this.getTagClass(tag) != null) {
            return true;
        }
        return this.getConstant(tag, null) != null;
    }

    @Override
    public void setConfigurationProperty(String property, String value) {
        if (log.isDebugEnabled()) {
            log.debug("setConfigurationProperty(" + property + ", " + value + ")");
        }
        if (CONFIG_IMPORT_PACKAGE.equals(property)) {
            this.importPackage(value);
        }
    }

    @Override
    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        Class type;
        if (log.isTraceEnabled()) {
            log.trace("setProperty(" + obj + ", " + field + ", " + value + ")");
        }
        field = this.resolveField(obj, field);
        Inspector ins = new Inspector(obj);
        if (value instanceof List && (type = ins.getType(field)) != null && type.isArray()) {
            List list = (List)value;
            Object[] array = (Object[])Array.newInstance(type.getComponentType(), list.size());
            value = array = list.toArray(array);
        }
        ins.set(field, value);
    }

    @Override
    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
        if (log.isTraceEnabled()) {
            log.trace("setTextProperty(" + obj + ", " + field + ", " + value + ")");
        }
        field = this.resolveField(obj, field);
        Inspector ins = new Inspector(obj);
        Class type = ins.getType(field);
        if (ins.hasMutator(field, String.class) && (!(ins.getObject() instanceof Map) || Object.class.equals((Object)type)) && !Object.class.equals((Object)type)) {
            ins.set(field, value, String.class);
            return;
        }
        if (type == null) {
            type = ins.getDynamicType();
        }
        if (type == null) {
            throw new RuntimeException("Attribute is invalid:" + field);
        }
        Object v = this.getConstant(value, obj.getClass());
        if (v == null) {
            v = Inspector.constructFromString(value, type);
        }
        if (v == null) {
            throw new RuntimeException("Could not translate value[" + value + "] into appropriate type for [" + field + "] type [" + type + "].");
        }
        ins.set(field, v);
    }

    @Override
    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        Class type = ins.getType(field = this.resolveField(obj, field));
        if (type != null && type.isArray()) {
            if (Object[].class.isAssignableFrom(type)) {
                return List.class;
            }
            return type;
        }
        return ins.getType(field);
    }

    @Override
    public boolean isPropertyMutable(Object obj, String field, ObjectXmlReader reader) {
        Inspector ins = new Inspector(obj);
        return ins.getMutableType(field = this.resolveField(obj, field)) != null;
    }

    @Override
    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        field = this.resolveField(obj, field);
        Inspector ins = new Inspector(obj);
        return (Collection)ins.get(field);
    }

    @Override
    public Object getProperty(Object obj, String field, ObjectXmlReader reader) {
        field = this.resolveField(obj, field);
        Inspector ins = new Inspector(obj);
        return ins.get(field);
    }

    protected boolean ignoreAttribute(String name, ObjectXmlReader reader) {
        return reader.ignoreAttribute(name) || name.startsWith("_");
    }

    protected void setObjectProperties(Object obj, Attributes atts, ObjectXmlReader reader) {
        if (atts.getLength() == 0) {
            return;
        }
        if (obj == null) {
            throw new RuntimeException("Cannot set attributes of null object.");
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getQName(i);
            if (this.ignoreAttribute(name, reader)) continue;
            this.setTextProperty(obj, name, atts.getValue(i), reader);
        }
    }

    @Override
    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        Object bean;
        String ctorVal;
        if ("null".equals(tag)) {
            return null;
        }
        Class type = this.getTagClass(tag);
        if (type == null) {
            Object result = this.getConstant(tag, null);
            if (result != null) {
                if (log.isDebugEnabled()) {
                    log.debug("createObject() constant:" + result);
                }
                return result;
            }
            throw new RuntimeException("Class not found for tag:" + tag);
        }
        if (log.isDebugEnabled()) {
            log.debug("createObject() type:" + type);
        }
        if ((ctorVal = atts.getValue("_ctor")) != null) {
            bean = Inspector.constructFromString(ctorVal, type);
            if (bean == null) {
                throw new RuntimeException("Unable to instantiate type:" + type + " from string.");
            }
        } else {
            bean = Inspector.newInstance(type);
        }
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }

    @Override
    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        if (obj instanceof Fixable) {
            ((Fixable)obj).setFixed(true);
        }
        return obj;
    }
}

