/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.progeeks.util.ClassRegistry;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.AbstractObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.progeeks.util.xml.XmlException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRegistryHandler
extends AbstractObjectHandler {
    static Log log = Log.getLog(ClassRegistryHandler.class);
    private List<String> packages = new ArrayList<String>();
    private Map<String, Class> classCache = new HashMap<String, Class>();

    public void importPackage(String packageName) {
        this.packages.add(packageName);
    }

    public void setPackages(List<String> packages) {
        if (this.packages == packages) {
            return;
        }
        this.packages.clear();
        this.packages.addAll(packages);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    protected Class getClass(String fullName) throws XmlException {
        if (log.isDebugEnabled()) {
            log.debug("getClass(" + fullName + ")");
        }
        try {
            Thread t = Thread.currentThread();
            return t.getContextClassLoader().loadClass(fullName);
        }
        catch (ClassNotFoundException e) {
            log.debug("Class not found:" + fullName);
            return null;
        }
    }

    protected Class getClass(String pkg, String name) throws XmlException {
        String className;
        Class type;
        if (log.isDebugEnabled()) {
            log.debug("getClass( " + pkg + ", " + name + " )");
        }
        if ((type = this.getClass(className = pkg + "." + name)) != null) {
            return type;
        }
        int split = className.lastIndexOf(46);
        if (split > 0) {
            String inner = className.substring(split + 1);
            String outer = className.substring(0, split);
            String full = outer + "$" + inner;
            type = this.getClass(outer);
            if (type == null) {
                outer = pkg + "." + outer;
                full = pkg + "." + full;
                type = this.getClass(outer);
            }
            if (type != null) {
                Class<?>[] list = type.getClasses();
                type = null;
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].getName().equals(full)) continue;
                    type = list[i];
                    break;
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getTagClass(String tag) throws XmlException {
        Class type;
        if (tag == null || tag.length() == 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTagClass(" + tag + ")");
        }
        if ((type = this.classCache.get(tag)) != null) {
            return type;
        }
        try {
            type = this.getClass(tag);
            if (type != null) {
                Class clazz = type;
                return clazz;
            }
            String name = tag.length() > 1 ? tag.substring(0, 1).toUpperCase() + tag.substring(1) : tag.toUpperCase();
            String className = name;
            type = this.getClass(className);
            if (type != null) {
                Class clazz = type;
                return clazz;
            }
            Iterator<String> i = this.packages.iterator();
            while (i.hasNext()) {
                type = this.getClass(i.next(), name);
                if (type == null) continue;
                Class clazz = type;
                return clazz;
            }
            Class clazz = null;
            return clazz;
        }
        finally {
            if (type != null) {
                this.classCache.put(tag, type);
            }
        }
    }

    @Override
    public boolean canHandle(String tag) {
        return "classRegistry".equals(tag);
    }

    @Override
    public void setConfigurationProperty(String property, String value) {
        if (log.isDebugEnabled()) {
            log.debug("setConfigurationProperty(" + property + ", " + value + ")");
        }
        if ("importPackage".equals(property)) {
            this.importPackage(value);
        }
    }

    @Override
    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        Class c = this.getTagClass(field);
        if (c == null) {
            throw new RuntimeException("Class not found for:" + field);
        }
        ((ClassRegistry)obj).put(c, value);
    }

    @Override
    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("No text properties available.");
    }

    @Override
    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        return Object.class;
    }

    @Override
    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Collection values not supported.");
    }

    @Override
    public Object getProperty(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("getProperty() not supported.");
    }

    @Override
    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        return new ClassRegistry();
    }
}

