/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.ArrayUtils;
import org.progeeks.util.InspectionException;
import org.progeeks.util.Inspector;
import org.progeeks.util.MethodIndex;
import org.progeeks.util.beans.BeanConfigurator;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethodHandler
extends BeanObjectHandler {
    private static final String MAPPING_KEY = ":mapping:";
    private static String tagRegex = "\\p{Alpha}[a-zA-Z0-9\\.\\-]*";
    private static String classRegex = "\\p{Alpha}[a-zA-Z0-9\\.]*";
    private static String nameRegex = "\\p{Alpha}[a-zA-Z0-9]*";
    private static Pattern mappingPattern = Pattern.compile("(" + tagRegex + ")\\s*=\\s*" + "(" + classRegex + ")\\.(" + nameRegex + ")" + "\\((.*)\\)");
    private static Pattern argPattern = Pattern.compile("(?:(" + classRegex + ")\\s*(\\[\\])*\\s+)?(" + tagRegex + ")\\s*");
    private Map<String, FactoryMapping> tags = new HashMap<String, FactoryMapping>();

    public void addFactoryMapping(String mapping) {
        Matcher m;
        if (log.isDebugEnabled()) {
            log.debug("addFactoryMapping(" + mapping + ")");
        }
        if (!(m = mappingPattern.matcher(mapping)).matches()) {
            throw new RuntimeException("Syntax error in mapping string:" + mapping);
        }
        String tagName = m.group(1);
        String className = m.group(2);
        String methodName = m.group(3);
        String argString = m.group(4).trim();
        if (log.isTraceEnabled()) {
            log.trace("tag:" + tagName);
            log.trace("class:" + className);
            log.trace("method:" + methodName);
            log.trace("args:" + argString);
        }
        if (argString.length() == 0) {
            this.addStaticMethodMapping(tagName, className, methodName);
            return;
        }
        String[] argArray = argString.split("\\s*,\\s*");
        FactoryArgument[] args = new FactoryArgument[argArray.length];
        for (int i = 0; i < argArray.length; ++i) {
            Matcher am = argPattern.matcher(argArray[i]);
            if (!am.matches()) {
                throw new RuntimeException("Argument syntax error for:" + argArray[i]);
            }
            String baseType = am.group(1);
            String brackets = am.group(2);
            if (brackets == null) {
                brackets = "";
            }
            String attributeName = am.group(3);
            args[i] = new FactoryArgument(attributeName, baseType, brackets.length() / 2);
        }
        this.addStaticMethodMapping(tagName, className, methodName, args);
    }

    public StaticMethodMapping addStaticMethodMapping(String tag, String type, String method) {
        return this.addStaticMethodMapping(tag, type, method, null);
    }

    public StaticMethodMapping addStaticMethodMapping(String tag, String type, String method, FactoryArgument ... args) {
        if (log.isDebugEnabled()) {
            log.debug("addStaticMethodMapping( " + tag + ", " + type + ", " + method + ", " + (args != null ? String.valueOf(Arrays.asList(args)) : "") + ")");
        }
        StaticMethodMapping mapping = new StaticMethodMapping(type, method, args);
        this.tags.put(tag, mapping);
        return mapping;
    }

    public void setFactoryMappings(List<String> mappings) {
        for (String s : mappings) {
            this.addFactoryMapping(s);
        }
    }

    @Override
    public boolean canHandle(String tag) {
        if (log.isDebugEnabled()) {
            log.debug("canHandle(" + tag + ")");
        }
        return this.tags.containsKey(tag);
    }

    @Override
    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        if (!(obj instanceof ListFactoryWrapper)) {
            return super.getPropertyClass(obj, field, reader);
        }
        ListFactoryWrapper wrapper = (ListFactoryWrapper)obj;
        BeanConfigurator bean = wrapper.factory;
        FactoryMapping mapping = wrapper.mapping;
        Class type = mapping.getArgumentType(field);
        if (type != null) {
            return type;
        }
        MethodIndex mi = MethodIndex.getMethodIndex(mapping.getResultType(), false);
        type = mi.getPropertyType(field);
        if (type != null) {
            return type;
        }
        return null;
    }

    @Override
    public boolean isPropertyMutable(Object obj, String field, ObjectXmlReader reader) {
        return this.getPropertyClass(obj, field, reader) != null;
    }

    @Override
    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        if (!(obj instanceof ListFactoryWrapper)) {
            return super.getPropertyCollection(obj, field, reader);
        }
        throw new UnsupportedOperationException("BeanConfigurator cannot provide pre-initialized collections. Object:" + obj + "  Field:" + field);
    }

    @Override
    public void setContainedText(String tag, Object obj, String text, ObjectXmlReader reader) {
        if (!(obj instanceof ListFactoryWrapper)) {
            super.setContainedText(tag, obj, text, reader);
            return;
        }
        ListFactoryWrapper wrapper = (ListFactoryWrapper)obj;
        wrapper.append(text);
    }

    @Override
    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        FactoryMapping mapping = this.tags.get(tag);
        if (mapping == null) {
            throw new RuntimeException("Mapping not found for tag:" + tag);
        }
        mapping.resolve();
        ListFactoryWrapper factory = new ListFactoryWrapper(mapping);
        this.setObjectProperties(factory, atts, reader);
        return factory;
    }

    protected Class getArgumentClass(String name) {
        Class result = Inspector.getClassForName(name);
        if (result != null) {
            return result;
        }
        return this.getTagClass(name);
    }

    protected Object coerceType(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (type.isArray()) {
            List list = (List)value;
            Object[] array = (Object[])Array.newInstance(type.getComponentType(), list.size());
            array = list.toArray(array);
            return array;
        }
        if (value instanceof CharSequence && (value = Inspector.constructFromString(value.toString(), type)) != null) {
            return value;
        }
        throw new RuntimeException("Could not convert value[" + value + "] to type:" + type);
    }

    @Override
    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        String buff;
        if (log.isDebugEnabled()) {
            log.debug("resolveObject(" + tag + ", " + obj + ")");
        }
        if (!(obj instanceof ListFactoryWrapper)) {
            return obj;
        }
        ListFactoryWrapper wrapper = (ListFactoryWrapper)obj;
        BeanConfigurator factory = wrapper.factory;
        FactoryMapping mapping = wrapper.mapping;
        mapping.resolve();
        Object[] parms = new Object[mapping.getArguments().size()];
        boolean collectionUsed = false;
        boolean textUsed = false;
        int index = 0;
        for (FactoryArgument arg : mapping.getArguments()) {
            if (log.isTraceEnabled()) {
                log.trace("Checking argument:" + arg);
            }
            Class targetType = arg.getType();
            Object value = factory.remove(arg.getName());
            if (log.isTraceEnabled()) {
                log.trace("value:" + value);
            }
            if (value == null && parms.length == 1) {
                if (wrapper.size() > 0 && (targetType.isArray() || Collection.class.isAssignableFrom(targetType))) {
                    log.trace("Value is the wrapped collection.");
                    value = wrapper;
                    collectionUsed = true;
                } else if (wrapper.size() == 1) {
                    Object o = wrapper.get(0);
                    if (targetType.isInstance(o)) {
                        log.trace("Value is the single wrapped element.");
                        value = o;
                    }
                    collectionUsed = true;
                } else if (CharSequence.class.isAssignableFrom(targetType) && wrapper.buffer.length() > 0) {
                    log.trace("Value is the contained text.");
                    value = wrapper.buffer;
                    textUsed = true;
                } else if (wrapper.buffer.toString().trim().length() > 0) {
                    log.trace("Value will be constructed from the ontained cleaned text.");
                    value = wrapper.buffer.toString().trim();
                    textUsed = true;
                }
            }
            parms[index++] = this.coerceType(targetType, value);
        }
        Object result = mapping.createObject(parms);
        if (factory.size() > 0) {
            factory.configureObject(result);
        }
        if (!textUsed && (buff = wrapper.buffer.toString().trim()).length() > 0) {
            log.warn("Tag[" + tag + "] contains ignored nested text:" + buff);
        }
        if (!collectionUsed && wrapper.size() > 0) {
            if (result instanceof Collection) {
                log.trace("Adding all of the nested elements to the result object.");
                ((Collection)result).addAll(wrapper);
            } else {
                throw new RuntimeException("Tag[" + tag + "] contains nested object elements" + " that cannot be used as the factory argument" + " or added to the result.");
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StaticMethodMapping
    implements FactoryMapping {
        private String className;
        private Class type;
        private String methodName;
        private Method method;
        private Map<String, FactoryArgument> args = new LinkedHashMap<String, FactoryArgument>();

        public StaticMethodMapping(String className, String methodName, FactoryArgument ... argArray) {
            this.className = className;
            this.methodName = methodName;
            if (argArray != null) {
                for (FactoryArgument arg : argArray) {
                    this.addArgument(arg);
                }
            }
        }

        @Override
        public Object createObject(Object[] parms) {
            try {
                Object result = this.method.invoke(null, parms);
                return result;
            }
            catch (Exception e) {
                throw new InspectionException("Error calling method[" + this.method + "] with parameters:" + (parms != null ? Arrays.asList(parms).toString() : ""));
            }
        }

        @Override
        public Collection<FactoryArgument> getArguments() {
            return Collections.unmodifiableCollection(this.args.values());
        }

        public void addArgument(FactoryArgument arg) {
            this.args.put(arg.getName(), arg);
        }

        @Override
        public void resolve() {
            if (this.method != null) {
                return;
            }
            if (this.type == null) {
                this.type = FactoryMethodHandler.this.getTagClass(this.className);
            }
            if (this.type == null) {
                throw new RuntimeException("Could not resolve class for:" + this.className);
            }
            Class[] parms = new Class[this.args.size()];
            int index = 0;
            for (FactoryArgument arg : this.args.values()) {
                parms[index++] = arg.getResolvedType(FactoryMethodHandler.this);
            }
            MethodIndex mi = MethodIndex.getMethodIndex(this.type, true);
            this.method = mi.findMethod(this.methodName, parms);
            if (this.method == null) {
                throw new RuntimeException("Could not resolve method:" + this.methodName + " with parameter types:" + Arrays.asList(parms));
            }
            index = 0;
            Class<?>[] argTypes = this.method.getParameterTypes();
            for (FactoryArgument arg : this.args.values()) {
                if (arg.type == null) {
                    arg.type = argTypes[index];
                }
                ++index;
            }
        }

        @Override
        public Class getResultType() {
            this.resolve();
            return this.method.getReturnType();
        }

        @Override
        public boolean isArgument(String name) {
            return this.args.containsKey(name);
        }

        @Override
        public Class getArgumentType(String name) {
            FactoryArgument arg = this.args.get(name);
            if (arg == null) {
                return null;
            }
            Class result = arg.getResolvedType(FactoryMethodHandler.this);
            if (result != null) {
                return result;
            }
            return Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface FactoryMapping {
        public Object createObject(Object[] var1);

        public Collection<FactoryArgument> getArguments();

        public Class getResultType();

        public boolean isArgument(String var1);

        public Class getArgumentType(String var1);

        public void resolve();
    }

    public static class FactoryArgument {
        private String name;
        private String typeName;
        private Class type;
        private int dimensions;

        public FactoryArgument(String name, Class type) {
            this(name, type, 0);
        }

        public FactoryArgument(String name, Class type, int dimensions) {
            this.name = name;
            this.type = type;
            this.dimensions = dimensions;
        }

        public FactoryArgument(String name, String typeName) {
            this(name, typeName, 0);
        }

        public FactoryArgument(String name, String typeName, int dimensions) {
            this.name = name;
            this.typeName = typeName;
            this.dimensions = dimensions;
        }

        public FactoryArgument(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getDimensions() {
            return this.dimensions;
        }

        public Class getType() {
            return this.type;
        }

        public Class getResolvedType(FactoryMethodHandler handler) {
            if (this.type == null && this.typeName != null) {
                this.type = handler.getArgumentClass(this.typeName);
                if (this.type == null) {
                    throw new RuntimeException("Could not resolve class for argument[" + this.name + "] type:" + this.typeName);
                }
                if (this.dimensions > 0) {
                    this.type = ArrayUtils.getArrayClass(this.type, this.dimensions);
                }
            }
            return this.type;
        }

        public String toString() {
            return "FactoryArgument[ name=" + this.name + ", type=" + this.type + ", typeName=" + this.typeName + ", dimensions=" + this.dimensions + "]";
        }
    }

    public static class ListFactoryWrapper
    extends ArrayList {
        private BeanConfigurator factory;
        private FactoryMapping mapping;
        private StringBuilder buffer = new StringBuilder();

        public ListFactoryWrapper(FactoryMapping mapping) {
            this.factory = new BeanConfigurator();
            this.mapping = mapping;
        }

        public void append(String text) {
            this.buffer.append(text);
        }

        public Object get(String name) {
            return this.factory.get(name);
        }

        public void set(String name, Object value) {
            this.factory.put(name, value);
        }

        public String toString() {
            return "ListFactoryWrapper[mapping=" + this.mapping + ", config=" + this.factory + ", listValue=" + super.toString() + "]";
        }
    }
}

