/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.AbstractObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class JndiObjectHandler
extends AbstractObjectHandler {
    static Log log = Log.getLog(JndiObjectHandler.class);
    public static final String HANDLER_TAG = "jndiLookup";
    private String handlerTag;

    public JndiObjectHandler() {
        this(HANDLER_TAG);
    }

    public JndiObjectHandler(String handlerTag) {
        this.handlerTag = handlerTag;
    }

    public boolean canHandle(String tag) {
        return this.handlerTag.equals(tag);
    }

    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
    }

    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        return null;
    }

    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        return null;
    }

    public Object getProperty(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("getProperty() not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        String jndiName = atts.getValue("name");
        if (jndiName == null || jndiName.equals("")) {
            log.warn("The name attribute was null or empty");
            return null;
        }
        InitialContext jndiContext = null;
        try {
            jndiContext = new InitialContext();
            Object object = jndiContext.lookup(jndiName);
            return object;
        }
        catch (NamingException e) {
            log.error("Couldn't lookup " + jndiName + " in JNDI.", e);
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            if (jndiContext != null) {
                try {
                    jndiContext.close();
                }
                catch (NamingException e) {
                    log.error("Error closing context.", e);
                }
            }
        }
    }
}

