/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.progeeks.util.xml.ObjectXmlReader;
import org.progeeks.util.xml.XmlException;
import org.progeeks.util.xml.XmlReader;

public class ObjectTransformingXmlReader
extends ObjectXmlReader {
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Transformer transformer;

    public ObjectTransformingXmlReader() {
    }

    public ObjectTransformingXmlReader(String rootTag) {
        super(rootTag);
    }

    public void setStyleSheetXml(String stylesheetXml) {
        this.setStyleSheet(new StringReader(stylesheetXml));
    }

    public void setStyleSheet(String stylesheet) {
        this.setStyleSheet(new StreamSource(stylesheet));
    }

    public void setStyleSheet(InputStream stylesheet) {
        this.setStyleSheet(new StreamSource(stylesheet));
    }

    public void setStyleSheet(Reader stylesheet) {
        this.setStyleSheet(new StreamSource(stylesheet));
    }

    protected void setStyleSheet(Source source) {
        try {
            this.transformer = this.transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to configure stylesheet.", e);
        }
    }

    protected void checkSourceXmlForStylesheet(Reader in) {
        try {
            Source stylesheet = this.transformerFactory.getAssociatedStylesheet(new StreamSource(in), null, null, null);
            if (stylesheet == null) {
                return;
            }
            this.transformer = this.transformerFactory.newTransformer(stylesheet);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to load stylesheet configuration.", e);
        }
    }

    protected void readXml(String systemId, Reader in) throws IOException, XmlException {
        if (this.transformer == null) {
            this.checkSourceXmlForStylesheet(new NonClosingReader(in));
        }
        if (this.transformer == null) {
            throw new RuntimeException("Stylesheet not-preconfigured and was not set in source XML.");
        }
        try {
            XmlReader.XmlHandler xmlHandler = new XmlReader.XmlHandler(this);
            StreamSource source = new StreamSource(in);
            source.setSystemId(systemId);
            SAXResult result = new SAXResult(xmlHandler);
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            log.error("Error transforming/parsing.", e);
            throw new XmlException("Failed to transform/parse document.", e);
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: java " + ObjectTransformingXmlReader.class.getName() + " input [stylesheet]");
            return;
        }
        ObjectTransformingXmlReader transformingReader = new ObjectTransformingXmlReader();
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        if (args.length == 2) {
            transformingReader.setStyleSheet(args[1]);
        } else {
            transformingReader.checkSourceXmlForStylesheet(new BufferedReader(new FileReader(args[0])));
        }
        if (transformingReader.transformer == null) {
            System.err.println("No stylesheet defined.");
            return;
        }
        StreamSource source = new StreamSource(reader);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformingReader.transformer.transform(source, result);
        System.out.print(writer.getBuffer().toString());
    }

    private static class NonClosingReader
    extends BufferedReader {
        private Reader reader;

        public NonClosingReader(Reader reader) {
            super(reader);
            this.reader = reader;
        }

        public void close() throws IOException {
            this.reader.reset();
        }
    }
}

