/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.XmlException;

public class RemappedBeanHandler
extends BeanObjectHandler {
    static Log log = Log.getLog();
    private Map<String, ObjectMapping> mappings = new HashMap<String, ObjectMapping>();
    private Map<Class, ObjectMapping> classMappings = new HashMap<Class, ObjectMapping>();

    public boolean canHandle(String tag) {
        return this.mappings.containsKey(tag);
    }

    protected Class getTagClass(String tag) throws XmlException {
        ObjectMapping m = this.getMapping(tag, null);
        if (m == null) {
            return null;
        }
        return m.getType();
    }

    public void addObjectMapping(String objectTag, Class targetType) {
        this.getMapping(objectTag, targetType);
    }

    public void addPropertyMapping(String objectTag, String sourceField, Class targetType, String targetProperty) {
        ObjectMapping m;
        if (log.isDebugEnabled()) {
            log.debug("addPropertyMapping( " + objectTag + ", " + sourceField + ", " + targetType + ", " + targetProperty + " )");
        }
        if ((m = this.getMapping(objectTag, targetType)) == null) {
            throw new RuntimeException("No object mapping defined for object tag:" + objectTag);
        }
        if (sourceField != null) {
            m.addProperty(sourceField, targetProperty);
        }
    }

    public void addPropertyMapping(String objectTag, String sourceField, String targetProperty) {
        this.addPropertyMapping(objectTag, sourceField, null, targetProperty);
    }

    public void addPropertyMapping(String mapping) {
        int split = mapping.indexOf("=");
        if (split < 0) {
            throw new RuntimeException("Invalid syntac for mapping, no '=':" + mapping);
        }
        String source = mapping.substring(0, split);
        String target = mapping.substring(split + 1);
        split = source.lastIndexOf(46);
        String objectTag = null;
        String sourceField = null;
        if (split < 0) {
            objectTag = source;
        } else {
            objectTag = source.substring(0, split);
            sourceField = source.substring(split + 1);
        }
        Class type = null;
        String targetProperty = null;
        if (sourceField == null) {
            type = this.getClass(target);
        } else {
            split = target.lastIndexOf(46);
            if (split >= 0) {
                String cname = target.substring(0, split);
                if (cname.length() > 0) {
                    type = this.getClass(cname);
                }
                targetProperty = target.substring(split + 1);
            } else {
                targetProperty = target;
            }
        }
        this.addPropertyMapping(objectTag, sourceField, type, targetProperty);
    }

    public void setPropertyMappings(List l) {
        for (String s : l) {
            this.addPropertyMapping(s);
        }
    }

    protected String resolveField(Object obj, String field) {
        if (obj == null) {
            return field;
        }
        ObjectMapping m = this.classMappings.get(obj.getClass());
        if (m == null) {
            return field;
        }
        return m.getProperty(field);
    }

    protected ObjectMapping getMapping(String objectTag, Class type) {
        ObjectMapping m = this.mappings.get(objectTag);
        if (m == null && type != null) {
            m = new ObjectMapping(type);
            this.mappings.put(objectTag, m);
            this.classMappings.put(type, m);
        }
        return m;
    }

    private static class ObjectMapping {
        private Class type;
        private Map<String, String> fields = new HashMap<String, String>();

        public ObjectMapping(Class type) {
            this.type = type;
        }

        public Class getType() {
            return this.type;
        }

        public void addProperty(String sourceField, String targetProperty) {
            this.fields.put(sourceField, targetProperty);
        }

        public String getProperty(String fieldTag) {
            String s = this.fields.get(fieldTag);
            if (s == null) {
                return fieldTag;
            }
            return s;
        }
    }
}

