/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.TagReader;
import org.progeeks.util.xml.XmlException;
import org.progeeks.util.xml.XmlReader;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

public class SimpleXmlReader
extends XmlReader {
    static Log log = Log.getLog(SimpleXmlReader.class);
    private Object rootObject = new LinkedHashMap();
    private SimpleTagReader simpleTagReader = new SimpleTagReader();

    public SimpleXmlReader() {
        this.setDefaultHandler(this.simpleTagReader);
    }

    public Object readObject(Reader in) throws IOException {
        this.reset();
        this.readXml(in);
        return this.rootObject;
    }

    public Object readObject(Document in) throws XmlException {
        this.reset();
        this.readXml(in);
        return this.rootObject;
    }

    public Object readObject(Document in, Transformer transformer) throws XmlException {
        this.reset();
        this.readXml(in, transformer);
        return this.rootObject;
    }

    public boolean isIgnoreAttributes() {
        return this.simpleTagReader.isIgnoreAttributes();
    }

    public void setIgnoreAttributes(boolean ignoreAttributes) {
        this.simpleTagReader.setIgnoreAttributes(ignoreAttributes);
    }

    public boolean getAllowMultipleStrings() {
        return this.simpleTagReader.getAllowMultipleStrings();
    }

    public void setAllowMultipleStrings(boolean f) {
        this.simpleTagReader.setAllowMultipleStrings(f);
    }

    protected void reset() {
        super.reset();
        this.rootObject = new LinkedHashMap();
    }

    public static void printValue(String indent, String name, Object value) {
        if (value instanceof List) {
            System.out.println(indent + name + ":");
            List l = (List)value;
            int index = 0;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                SimpleXmlReader.printValue(indent + "  ", "[" + index + "]", i.next());
                ++index;
            }
        } else if (value instanceof Map) {
            System.out.println(indent + name + ":");
            Map m = (Map)value;
            for (Map.Entry e : m.entrySet()) {
                SimpleXmlReader.printValue(indent + "  ", (String)e.getKey(), e.getValue());
            }
        } else {
            System.out.println(indent + name + ":" + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Log.initialize();
        SimpleXmlReader reader = new SimpleXmlReader();
        for (int i = 0; i < args.length; ++i) {
            FileReader in = new FileReader(args[i]);
            try {
                Object o = reader.readObject(in);
                SimpleXmlReader.printValue(" ", "root", o);
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    protected class SimpleTagReader
    extends TagReader {
        private boolean ignoreAttributes = false;
        private boolean allowMultipleStrings = true;

        protected SimpleTagReader() {
        }

        public Object tagStart(String tag, Attributes atts, Object current) throws XmlException {
            if (log.isDebugEnabled()) {
                log.debug("tagStart(" + tag + ", " + current + ")");
            }
            LinkedHashMap<String, String> node = new LinkedHashMap<String, String>();
            if (!this.ignoreAttributes) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = "@" + atts.getQName(i);
                    node.put(name, atts.getValue(i));
                }
            }
            return node;
        }

        public void tagEnd(String tag, String text, Object parent, Object tagObject) throws XmlException {
            Map p;
            Object previous;
            Object o;
            if (log.isDebugEnabled()) {
                log.debug("Stack depth:" + SimpleXmlReader.this.getStackSize() + "   tag end:" + tag);
                log.debug("tagEnd(" + tag + ", " + text + ", " + parent + ", " + tagObject + ")");
            }
            if (((Map)(o = tagObject)).isEmpty()) {
                o = text;
            }
            if (parent == null) {
                parent = SimpleXmlReader.this.rootObject;
            }
            if ((previous = (p = (Map)parent).get(tag)) instanceof List) {
                ((List)previous).add(o);
                return;
            }
            if (previous instanceof Map || previous != null && this.allowMultipleStrings) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(previous);
                l.add(o);
                p.put(tag, l);
                return;
            }
            p.put(tag, o);
        }

        public boolean isIgnoreAttributes() {
            return this.ignoreAttributes;
        }

        public void setIgnoreAttributes(boolean ignoreAttributes) {
            this.ignoreAttributes = ignoreAttributes;
        }

        public boolean getAllowMultipleStrings() {
            return this.allowMultipleStrings;
        }

        public void setAllowMultipleStrings(boolean f) {
            this.allowMultipleStrings = f;
        }
    }
}

