/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.progeeks.cmd.Command;
import org.progeeks.cmd.Result;
import org.progeeks.cmd.TargetedEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMap
extends HashMap<Object, Object> {
    static final long serialVersionUID = 1L;
    private boolean concatenate = true;

    public void setConcatenate(boolean flag) {
        this.concatenate = flag;
    }

    public boolean getConcatenate() {
        return this.concatenate;
    }

    public Result runCommand(Object key, Object target, boolean mustRun) {
        Object obj = this.get(key);
        if (obj == null && mustRun) {
            throw new RuntimeException("Command not found for key:" + key);
        }
        if (obj == null) {
            return null;
        }
        MapEnvironment env = new MapEnvironment(target);
        if (obj instanceof Collection) {
            for (Command cmd : (Collection)obj) {
                env.execute(cmd);
            }
            return null;
        }
        if (obj instanceof Command) {
            return env.execute((Command)obj);
        }
        throw new RuntimeException("Object not a command:" + obj);
    }

    public Result runCommand(Object key, Object target) {
        return this.runCommand(key, target, false);
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        if (oldValue == null || !this.getConcatenate()) {
            super.put(key, value);
            return oldValue;
        }
        ArrayList<Object> commands = null;
        if (oldValue instanceof Collection) {
            commands = (ArrayList<Object>)oldValue;
        } else {
            commands = new ArrayList<Object>();
            commands.add(oldValue);
            super.put(key, commands);
        }
        if (value instanceof Collection) {
            commands.addAll((Collection)value);
        } else {
            commands.add(value);
        }
        return oldValue;
    }

    private static class MapEnvironment
    implements TargetedEnvironment {
        private Object target;

        public MapEnvironment(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }

        public Result execute(Command cmd) {
            return cmd.execute(this);
        }
    }
}

