/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.cmd.stack;

import java.util.LinkedList;
import java.util.List;
import org.progeeks.cmd.Command;
import org.progeeks.cmd.Result;
import org.progeeks.cmd.stack.CommandProcessorStack;
import org.progeeks.cmd.stack.StackEnvironment;
import org.progeeks.cmd.stack.StackableCommandProcessor;

public class ForwardingStack
implements CommandProcessorStack,
StackEnvironment {
    private List<StackableCommandProcessor> cmdProcs = new LinkedList<StackableCommandProcessor>();

    public Result execute(Command cmd) {
        for (StackableCommandProcessor cmdProc : this.cmdProcs) {
            if (!cmdProc.canExecute(cmd)) continue;
            return cmdProc.execute(cmd);
        }
        throw new RuntimeException("There are no compatible command processors in the stack for cmd:" + cmd);
    }

    public void pushCommandProcessor(StackableCommandProcessor cmdProc) {
        this.cmdProcs.add(0, cmdProc);
        cmdProc.setStackEnvironment(this);
    }

    public StackableCommandProcessor popCommandProcessor() {
        if (this.cmdProcs.size() == 0) {
            throw new RuntimeException("Command processor stack is empty.");
        }
        StackableCommandProcessor cmdProc = this.cmdProcs.remove(0);
        cmdProc.setStackEnvironment(null);
        return cmdProc;
    }

    public StackableCommandProcessor peekCommandProcessor() {
        if (this.cmdProcs.size() == 0) {
            return null;
        }
        return this.cmdProcs.get(0);
    }
}

